package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AuthorizationServerPolicyRuleGroupCondition;
import com.okta.sdk.resource.model.AuthorizationServerPolicyRuleUserCondition;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Identifies Users and Groups that are used together
 */
@ApiModel(description = "Identifies Users and Groups that are used together")
@JsonPropertyOrder({ AuthorizationServerPolicyPeopleCondition.JSON_PROPERTY_GROUPS,
        AuthorizationServerPolicyPeopleCondition.JSON_PROPERTY_USERS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class AuthorizationServerPolicyPeopleCondition implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_GROUPS = "groups";
    private AuthorizationServerPolicyRuleGroupCondition groups;

    public static final String JSON_PROPERTY_USERS = "users";
    private AuthorizationServerPolicyRuleUserCondition users;

    public AuthorizationServerPolicyPeopleCondition() {
    }

    public AuthorizationServerPolicyPeopleCondition groups(AuthorizationServerPolicyRuleGroupCondition groups) {

        this.groups = groups;
        return this;
    }

    /**
     * Get groups
     *
     * @return groups
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_GROUPS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthorizationServerPolicyRuleGroupCondition getGroups() {
        return groups;
    }

    @JsonProperty(JSON_PROPERTY_GROUPS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGroups(AuthorizationServerPolicyRuleGroupCondition groups) {
        this.groups = groups;
    }

    public AuthorizationServerPolicyPeopleCondition users(AuthorizationServerPolicyRuleUserCondition users) {

        this.users = users;
        return this;
    }

    /**
     * Get users
     *
     * @return users
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USERS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthorizationServerPolicyRuleUserCondition getUsers() {
        return users;
    }

    @JsonProperty(JSON_PROPERTY_USERS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUsers(AuthorizationServerPolicyRuleUserCondition users) {
        this.users = users;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthorizationServerPolicyPeopleCondition authorizationServerPolicyPeopleCondition = (AuthorizationServerPolicyPeopleCondition) o;
        return Objects.equals(this.groups, authorizationServerPolicyPeopleCondition.groups)
                && Objects.equals(this.users, authorizationServerPolicyPeopleCondition.users);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(groups, users);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthorizationServerPolicyPeopleCondition {\n");
        sb.append("    groups: ").append(toIndentedString(groups)).append("\n");
        sb.append("    users: ").append(toIndentedString(users)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
