package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The schedule of auto-update configured by admin.
 */
@ApiModel(description = "The schedule of auto-update configured by admin.")
@JsonPropertyOrder({ AutoUpdateSchedule.JSON_PROPERTY_CRON, AutoUpdateSchedule.JSON_PROPERTY_DELAY,
        AutoUpdateSchedule.JSON_PROPERTY_DURATION, AutoUpdateSchedule.JSON_PROPERTY_LAST_UPDATED,
        AutoUpdateSchedule.JSON_PROPERTY_TIMEZONE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class AutoUpdateSchedule implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CRON = "cron";
    private String cron;

    public static final String JSON_PROPERTY_DELAY = "delay";
    private Integer delay;

    public static final String JSON_PROPERTY_DURATION = "duration";
    private Integer duration;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_TIMEZONE = "timezone";
    private String timezone;

    public AutoUpdateSchedule() {
    }

    public AutoUpdateSchedule cron(String cron) {

        this.cron = cron;
        return this;
    }

    /**
     * Get cron
     *
     * @return cron
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CRON)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCron() {
        return cron;
    }

    @JsonProperty(JSON_PROPERTY_CRON)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCron(String cron) {
        this.cron = cron;
    }

    public AutoUpdateSchedule delay(Integer delay) {

        this.delay = delay;
        return this;
    }

    /**
     * delay in days
     *
     * @return delay
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "delay in days")
    @JsonProperty(JSON_PROPERTY_DELAY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getDelay() {
        return delay;
    }

    @JsonProperty(JSON_PROPERTY_DELAY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDelay(Integer delay) {
        this.delay = delay;
    }

    public AutoUpdateSchedule duration(Integer duration) {

        this.duration = duration;
        return this;
    }

    /**
     * duration in minutes
     *
     * @return duration
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "duration in minutes")
    @JsonProperty(JSON_PROPERTY_DURATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getDuration() {
        return duration;
    }

    @JsonProperty(JSON_PROPERTY_DURATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public AutoUpdateSchedule lastUpdated(OffsetDateTime lastUpdated) {

        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * last time when the updated finished (success or failed, exclude cancelled), null if job haven&#39;t finished once
     * yet.
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "last time when the updated finished (success or failed, exclude cancelled), null if job haven't finished once yet.")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLastUpdated(OffsetDateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public AutoUpdateSchedule timezone(String timezone) {

        this.timezone = timezone;
        return this;
    }

    /**
     * Get timezone
     *
     * @return timezone
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TIMEZONE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getTimezone() {
        return timezone;
    }

    @JsonProperty(JSON_PROPERTY_TIMEZONE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AutoUpdateSchedule autoUpdateSchedule = (AutoUpdateSchedule) o;
        return Objects.equals(this.cron, autoUpdateSchedule.cron)
                && Objects.equals(this.delay, autoUpdateSchedule.delay)
                && Objects.equals(this.duration, autoUpdateSchedule.duration)
                && Objects.equals(this.lastUpdated, autoUpdateSchedule.lastUpdated)
                && Objects.equals(this.timezone, autoUpdateSchedule.timezone);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(cron, delay, duration, lastUpdated, timezone);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AutoUpdateSchedule {\n");
        sb.append("    cron: ").append(toIndentedString(cron)).append("\n");
        sb.append("    delay: ").append(toIndentedString(delay)).append("\n");
        sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
