package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.BundleEntitlementsResponseLinksBundle;
import com.okta.sdk.resource.model.BundleEntitlementsResponseLinksNext;
import com.okta.sdk.resource.model.HrefObjectSelfLink;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available using the [JSON
 * Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification
 */
@ApiModel(description = "Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available using the [JSON Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification")
@JsonPropertyOrder({ BundleEntitlementsResponseLinks.JSON_PROPERTY_NEXT,
        BundleEntitlementsResponseLinks.JSON_PROPERTY_SELF, BundleEntitlementsResponseLinks.JSON_PROPERTY_BUNDLE })
@JsonTypeName("BundleEntitlementsResponse__links")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class BundleEntitlementsResponseLinks implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_NEXT = "next";
    private BundleEntitlementsResponseLinksNext next;

    public static final String JSON_PROPERTY_SELF = "self";
    private HrefObjectSelfLink self;

    public static final String JSON_PROPERTY_BUNDLE = "bundle";
    private BundleEntitlementsResponseLinksBundle bundle;

    public BundleEntitlementsResponseLinks() {
    }

    public BundleEntitlementsResponseLinks next(BundleEntitlementsResponseLinksNext next) {

        this.next = next;
        return this;
    }

    /**
     * Get next
     *
     * @return next
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_NEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public BundleEntitlementsResponseLinksNext getNext() {
        return next;
    }

    @JsonProperty(JSON_PROPERTY_NEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setNext(BundleEntitlementsResponseLinksNext next) {
        this.next = next;
    }

    public BundleEntitlementsResponseLinks self(HrefObjectSelfLink self) {

        this.self = self;
        return this;
    }

    /**
     * Get self
     *
     * @return self
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectSelfLink getSelf() {
        return self;
    }

    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSelf(HrefObjectSelfLink self) {
        this.self = self;
    }

    public BundleEntitlementsResponseLinks bundle(BundleEntitlementsResponseLinksBundle bundle) {

        this.bundle = bundle;
        return this;
    }

    /**
     * Get bundle
     *
     * @return bundle
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_BUNDLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public BundleEntitlementsResponseLinksBundle getBundle() {
        return bundle;
    }

    @JsonProperty(JSON_PROPERTY_BUNDLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setBundle(BundleEntitlementsResponseLinksBundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BundleEntitlementsResponseLinks bundleEntitlementsResponseLinks = (BundleEntitlementsResponseLinks) o;
        return Objects.equals(this.next, bundleEntitlementsResponseLinks.next)
                && Objects.equals(this.self, bundleEntitlementsResponseLinks.self)
                && Objects.equals(this.bundle, bundleEntitlementsResponseLinks.bundle);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(next, self, bundle);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BundleEntitlementsResponseLinks {\n");
        sb.append("    next: ").append(toIndentedString(next)).append("\n");
        sb.append("    self: ").append(toIndentedString(self)).append("\n");
        sb.append("    bundle: ").append(toIndentedString(bundle)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
