package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ApplicationType;
import com.okta.sdk.resource.model.EndpointAuthMethod;
import com.okta.sdk.resource.model.GrantType;
import com.okta.sdk.resource.model.ResponseType;
import com.okta.sdk.resource.model.SigningAlgorithm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Client
 */
@JsonPropertyOrder({ Client.JSON_PROPERTY_APPLICATION_TYPE, Client.JSON_PROPERTY_CLIENT_ID,
        Client.JSON_PROPERTY_CLIENT_ID_ISSUED_AT, Client.JSON_PROPERTY_CLIENT_NAME, Client.JSON_PROPERTY_CLIENT_SECRET,
        Client.JSON_PROPERTY_CLIENT_SECRET_EXPIRES_AT, Client.JSON_PROPERTY_FRONTCHANNEL_LOGOUT_SESSION_REQUIRED,
        Client.JSON_PROPERTY_FRONTCHANNEL_LOGOUT_URI, Client.JSON_PROPERTY_GRANT_TYPES,
        Client.JSON_PROPERTY_INITIATE_LOGIN_URI, Client.JSON_PROPERTY_JWKS_URI, Client.JSON_PROPERTY_LOGO_URI,
        Client.JSON_PROPERTY_POLICY_URI, Client.JSON_PROPERTY_POST_LOGOUT_REDIRECT_URIS,
        Client.JSON_PROPERTY_REDIRECT_URIS, Client.JSON_PROPERTY_REQUEST_OBJECT_SIGNING_ALG,
        Client.JSON_PROPERTY_RESPONSE_TYPES, Client.JSON_PROPERTY_TOKEN_ENDPOINT_AUTH_METHOD,
        Client.JSON_PROPERTY_TOS_URI })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class Client implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_APPLICATION_TYPE = "application_type";
    private ApplicationType applicationType;

    public static final String JSON_PROPERTY_CLIENT_ID = "client_id";
    private String clientId;

    public static final String JSON_PROPERTY_CLIENT_ID_ISSUED_AT = "client_id_issued_at";
    private Integer clientIdIssuedAt;

    public static final String JSON_PROPERTY_CLIENT_NAME = "client_name";
    private String clientName;

    public static final String JSON_PROPERTY_CLIENT_SECRET = "client_secret";
    private JsonNullable<String> clientSecret = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_CLIENT_SECRET_EXPIRES_AT = "client_secret_expires_at";
    private JsonNullable<Integer> clientSecretExpiresAt = JsonNullable.<Integer> undefined();

    public static final String JSON_PROPERTY_FRONTCHANNEL_LOGOUT_SESSION_REQUIRED = "frontchannel_logout_session_required";
    private Boolean frontchannelLogoutSessionRequired;

    public static final String JSON_PROPERTY_FRONTCHANNEL_LOGOUT_URI = "frontchannel_logout_uri";
    private JsonNullable<String> frontchannelLogoutUri = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_GRANT_TYPES = "grant_types";
    private List<GrantType> grantTypes = null;

    public static final String JSON_PROPERTY_INITIATE_LOGIN_URI = "initiate_login_uri";
    private String initiateLoginUri;

    public static final String JSON_PROPERTY_JWKS_URI = "jwks_uri";
    private String jwksUri;

    public static final String JSON_PROPERTY_LOGO_URI = "logo_uri";
    private JsonNullable<String> logoUri = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_POLICY_URI = "policy_uri";
    private JsonNullable<String> policyUri = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_POST_LOGOUT_REDIRECT_URIS = "post_logout_redirect_uris";
    private List<String> postLogoutRedirectUris = null;

    public static final String JSON_PROPERTY_REDIRECT_URIS = "redirect_uris";
    private List<String> redirectUris = null;

    public static final String JSON_PROPERTY_REQUEST_OBJECT_SIGNING_ALG = "request_object_signing_alg";
    private List<SigningAlgorithm> requestObjectSigningAlg = null;

    public static final String JSON_PROPERTY_RESPONSE_TYPES = "response_types";
    private List<ResponseType> responseTypes = null;

    public static final String JSON_PROPERTY_TOKEN_ENDPOINT_AUTH_METHOD = "token_endpoint_auth_method";
    private EndpointAuthMethod tokenEndpointAuthMethod;

    public static final String JSON_PROPERTY_TOS_URI = "tos_uri";
    private JsonNullable<String> tosUri = JsonNullable.<String> undefined();

    public Client() {
    }

    /*
     * @JsonCreator public Client(
     *
     * @JsonProperty(JSON_PROPERTY_CLIENT_ID) String clientId,
     *
     * @JsonProperty(JSON_PROPERTY_CLIENT_ID_ISSUED_AT) Integer clientIdIssuedAt,
     *
     * @JsonProperty(JSON_PROPERTY_CLIENT_SECRET) String clientSecret,
     *
     * @JsonProperty(JSON_PROPERTY_CLIENT_SECRET_EXPIRES_AT) Integer clientSecretExpiresAt ) { this(); this.clientId =
     * clientId; this.clientIdIssuedAt = clientIdIssuedAt; this.clientSecret = clientSecret; this.clientSecretExpiresAt
     * = clientSecretExpiresAt; }
     */

    public Client applicationType(ApplicationType applicationType) {

        this.applicationType = applicationType;
        return this;
    }

    /**
     * Get applicationType
     *
     * @return applicationType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_APPLICATION_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationType getApplicationType() {
        return applicationType;
    }

    @JsonProperty(JSON_PROPERTY_APPLICATION_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    /**
     * Unique key for the client application. The &#x60;client_id&#x60; is immutable. When you create a client
     * Application, you can&#39;t specify the &#x60;client_id&#x60; because Okta uses the application ID for the
     * &#x60;client_id&#x60;.
     *
     * @return clientId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Unique key for the client application. The `client_id` is immutable. When you create a client Application, you can't specify the `client_id` because Okta uses the application ID for the `client_id`.")
    @JsonProperty(JSON_PROPERTY_CLIENT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getClientId() {
        return clientId;
    }

    /**
     * Time at which the &#x60;client_id&#x60; was issued (measured in unix seconds)
     *
     * @return clientIdIssuedAt
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Time at which the `client_id` was issued (measured in unix seconds)")
    @JsonProperty(JSON_PROPERTY_CLIENT_ID_ISSUED_AT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getClientIdIssuedAt() {
        return clientIdIssuedAt;
    }

    public Client clientName(String clientName) {

        this.clientName = clientName;
        return this;
    }

    /**
     * Human-readable string name of the client application
     *
     * @return clientName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Human-readable string name of the client application")
    @JsonProperty(JSON_PROPERTY_CLIENT_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getClientName() {
        return clientName;
    }

    @JsonProperty(JSON_PROPERTY_CLIENT_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    /**
     * OAuth 2.0 client secret string (used for confidential clients). The &#x60;client_secret&#x60; is shown only on
     * the response of the creation or update of a client Application (and only if the
     * &#x60;token_endpoint_auth_method&#x60; is one that requires a client secret). You can&#39;t specify the
     * &#x60;client_secret&#x60;. If the &#x60;token_endpoint_auth_method&#x60; requires one, Okta generates a random
     * &#x60;client_secret&#x60; for the client Application.
     *
     * @return clientSecret
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "OAuth 2.0 client secret string (used for confidential clients). The `client_secret` is shown only on the response of the creation or update of a client Application (and only if the `token_endpoint_auth_method` is one that requires a client secret). You can't specify the `client_secret`. If the `token_endpoint_auth_method` requires one, Okta generates a random `client_secret` for the client Application.")
    @JsonIgnore

    public String getClientSecret() {

        if (clientSecret == null) {
            clientSecret = JsonNullable.<String> undefined();
        }
        return clientSecret.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_CLIENT_SECRET)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getClientSecret_JsonNullable() {
        return clientSecret;
    }

    @JsonProperty(JSON_PROPERTY_CLIENT_SECRET)
    private void setClientSecret_JsonNullable(JsonNullable<String> clientSecret) {
        this.clientSecret = clientSecret;
    }

    /**
     * Time at which the &#x60;client_secret&#x60; expires or 0 if it doesn&#39;t expire (measured in unix seconds)
     * minimum: 0
     *
     * @return clientSecretExpiresAt
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Time at which the `client_secret` expires or 0 if it doesn't expire (measured in unix seconds)")
    @JsonIgnore

    public Integer getClientSecretExpiresAt() {

        if (clientSecretExpiresAt == null) {
            clientSecretExpiresAt = JsonNullable.<Integer> undefined();
        }
        return clientSecretExpiresAt.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_CLIENT_SECRET_EXPIRES_AT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<Integer> getClientSecretExpiresAt_JsonNullable() {
        return clientSecretExpiresAt;
    }

    @JsonProperty(JSON_PROPERTY_CLIENT_SECRET_EXPIRES_AT)
    private void setClientSecretExpiresAt_JsonNullable(JsonNullable<Integer> clientSecretExpiresAt) {
        this.clientSecretExpiresAt = clientSecretExpiresAt;
    }

    public Client frontchannelLogoutSessionRequired(Boolean frontchannelLogoutSessionRequired) {

        this.frontchannelLogoutSessionRequired = frontchannelLogoutSessionRequired;
        return this;
    }

    /**
     * Include user session details
     *
     * @return frontchannelLogoutSessionRequired
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Include user session details")
    @JsonProperty(JSON_PROPERTY_FRONTCHANNEL_LOGOUT_SESSION_REQUIRED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getFrontchannelLogoutSessionRequired() {
        return frontchannelLogoutSessionRequired;
    }

    @JsonProperty(JSON_PROPERTY_FRONTCHANNEL_LOGOUT_SESSION_REQUIRED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFrontchannelLogoutSessionRequired(Boolean frontchannelLogoutSessionRequired) {
        this.frontchannelLogoutSessionRequired = frontchannelLogoutSessionRequired;
    }

    public Client frontchannelLogoutUri(String frontchannelLogoutUri) {
        this.frontchannelLogoutUri = JsonNullable.<String> of(frontchannelLogoutUri);

        return this;
    }

    /**
     * URL where Okta sends the logout request
     *
     * @return frontchannelLogoutUri
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "URL where Okta sends the logout request")
    @JsonIgnore

    public String getFrontchannelLogoutUri() {
        return frontchannelLogoutUri.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_FRONTCHANNEL_LOGOUT_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getFrontchannelLogoutUri_JsonNullable() {
        return frontchannelLogoutUri;
    }

    @JsonProperty(JSON_PROPERTY_FRONTCHANNEL_LOGOUT_URI)
    public void setFrontchannelLogoutUri_JsonNullable(JsonNullable<String> frontchannelLogoutUri) {
        this.frontchannelLogoutUri = frontchannelLogoutUri;
    }

    public void setFrontchannelLogoutUri(String frontchannelLogoutUri) {
        this.frontchannelLogoutUri = JsonNullable.<String> of(frontchannelLogoutUri);
    }

    public Client grantTypes(List<GrantType> grantTypes) {

        this.grantTypes = grantTypes;
        return this;
    }

    public Client addgrantTypesItem(GrantType grantTypesItem) {
        if (this.grantTypes == null) {
            this.grantTypes = new ArrayList<>();
        }
        this.grantTypes.add(grantTypesItem);
        return this;
    }

    /**
     * Array of OAuth 2.0 grant type strings. Default value: &#x60;[authorization_code]&#x60;
     *
     * @return grantTypes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Array of OAuth 2.0 grant type strings. Default value: `[authorization_code]`")
    @JsonProperty(JSON_PROPERTY_GRANT_TYPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<GrantType> getGrantTypes() {
        return grantTypes;
    }

    @JsonProperty(JSON_PROPERTY_GRANT_TYPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGrantTypes(List<GrantType> grantTypes) {
        this.grantTypes = grantTypes;
    }

    public Client initiateLoginUri(String initiateLoginUri) {

        this.initiateLoginUri = initiateLoginUri;
        return this;
    }

    /**
     * URL that a third party can use to initiate a login by the client
     *
     * @return initiateLoginUri
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "URL that a third party can use to initiate a login by the client")
    @JsonProperty(JSON_PROPERTY_INITIATE_LOGIN_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getInitiateLoginUri() {
        return initiateLoginUri;
    }

    @JsonProperty(JSON_PROPERTY_INITIATE_LOGIN_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setInitiateLoginUri(String initiateLoginUri) {
        this.initiateLoginUri = initiateLoginUri;
    }

    public Client jwksUri(String jwksUri) {

        this.jwksUri = jwksUri;
        return this;
    }

    /**
     * URL string that references a [JSON Web Key Set](https://tools.ietf.org/html/rfc7517#section-5) for validating
     * JWTs presented to Okta
     *
     * @return jwksUri
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "URL string that references a [JSON Web Key Set](https://tools.ietf.org/html/rfc7517#section-5) for validating JWTs presented to Okta")
    @JsonProperty(JSON_PROPERTY_JWKS_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getJwksUri() {
        return jwksUri;
    }

    @JsonProperty(JSON_PROPERTY_JWKS_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public Client logoUri(String logoUri) {
        this.logoUri = JsonNullable.<String> of(logoUri);

        return this;
    }

    /**
     * URL string that references a logo for the client consent dialog (not the sign-in dialog)
     *
     * @return logoUri
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "URL string that references a logo for the client consent dialog (not the sign-in dialog)")
    @JsonIgnore

    public String getLogoUri() {
        return logoUri.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_LOGO_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getLogoUri_JsonNullable() {
        return logoUri;
    }

    @JsonProperty(JSON_PROPERTY_LOGO_URI)
    public void setLogoUri_JsonNullable(JsonNullable<String> logoUri) {
        this.logoUri = logoUri;
    }

    public void setLogoUri(String logoUri) {
        this.logoUri = JsonNullable.<String> of(logoUri);
    }

    public Client policyUri(String policyUri) {
        this.policyUri = JsonNullable.<String> of(policyUri);

        return this;
    }

    /**
     * URL string of a web page providing the client&#39;s policy document
     *
     * @return policyUri
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "URL string of a web page providing the client's policy document")
    @JsonIgnore

    public String getPolicyUri() {
        return policyUri.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_POLICY_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getPolicyUri_JsonNullable() {
        return policyUri;
    }

    @JsonProperty(JSON_PROPERTY_POLICY_URI)
    public void setPolicyUri_JsonNullable(JsonNullable<String> policyUri) {
        this.policyUri = policyUri;
    }

    public void setPolicyUri(String policyUri) {
        this.policyUri = JsonNullable.<String> of(policyUri);
    }

    public Client postLogoutRedirectUris(List<String> postLogoutRedirectUris) {

        this.postLogoutRedirectUris = postLogoutRedirectUris;
        return this;
    }

    public Client addpostLogoutRedirectUrisItem(String postLogoutRedirectUrisItem) {
        if (this.postLogoutRedirectUris == null) {
            this.postLogoutRedirectUris = new ArrayList<>();
        }
        this.postLogoutRedirectUris.add(postLogoutRedirectUrisItem);
        return this;
    }

    /**
     * Array of redirection URI strings for use for relying party initiated logouts
     *
     * @return postLogoutRedirectUris
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Array of redirection URI strings for use for relying party initiated logouts")
    @JsonProperty(JSON_PROPERTY_POST_LOGOUT_REDIRECT_URIS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getPostLogoutRedirectUris() {
        return postLogoutRedirectUris;
    }

    @JsonProperty(JSON_PROPERTY_POST_LOGOUT_REDIRECT_URIS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPostLogoutRedirectUris(List<String> postLogoutRedirectUris) {
        this.postLogoutRedirectUris = postLogoutRedirectUris;
    }

    public Client redirectUris(List<String> redirectUris) {

        this.redirectUris = redirectUris;
        return this;
    }

    public Client addredirectUrisItem(String redirectUrisItem) {
        if (this.redirectUris == null) {
            this.redirectUris = new ArrayList<>();
        }
        this.redirectUris.add(redirectUrisItem);
        return this;
    }

    /**
     * Array of redirection URI strings for use in redirect-based flows. All redirect URIs must be absolute URIs and
     * must not include a fragment component. At least one redirect URI and response type is required for all client
     * types, with the following exceptions: If the client uses the Resource Owner Password flow (if
     * &#x60;grant_type&#x60; contains the value password) or the Client Credentials flow (if &#x60;grant_type&#x60;
     * contains the value &#x60;client_credentials&#x60;), then no redirect URI or response type is necessary. In these
     * cases, you can pass either null or an empty array for these attributes.
     *
     * @return redirectUris
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Array of redirection URI strings for use in redirect-based flows. All redirect URIs must be absolute URIs and must not include a fragment component. At least one redirect URI and response type is required for all client types, with the following exceptions: If the client uses the Resource Owner Password flow (if `grant_type` contains the value password) or the Client Credentials flow (if `grant_type` contains the value `client_credentials`), then no redirect URI or response type is necessary. In these cases, you can pass either null or an empty array for these attributes.")
    @JsonProperty(JSON_PROPERTY_REDIRECT_URIS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getRedirectUris() {
        return redirectUris;
    }

    @JsonProperty(JSON_PROPERTY_REDIRECT_URIS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public Client requestObjectSigningAlg(List<SigningAlgorithm> requestObjectSigningAlg) {

        this.requestObjectSigningAlg = requestObjectSigningAlg;
        return this;
    }

    public Client addrequestObjectSigningAlgItem(SigningAlgorithm requestObjectSigningAlgItem) {
        if (this.requestObjectSigningAlg == null) {
            this.requestObjectSigningAlg = new ArrayList<>();
        }
        this.requestObjectSigningAlg.add(requestObjectSigningAlgItem);
        return this;
    }

    /**
     * The type of [JSON Web Key Set](https://tools.ietf.org/html/rfc7517#section-5) algorithm that must be used for
     * signing request objects
     *
     * @return requestObjectSigningAlg
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The type of [JSON Web Key Set](https://tools.ietf.org/html/rfc7517#section-5) algorithm that must be used for signing request objects")
    @JsonProperty(JSON_PROPERTY_REQUEST_OBJECT_SIGNING_ALG)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<SigningAlgorithm> getRequestObjectSigningAlg() {
        return requestObjectSigningAlg;
    }

    @JsonProperty(JSON_PROPERTY_REQUEST_OBJECT_SIGNING_ALG)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRequestObjectSigningAlg(List<SigningAlgorithm> requestObjectSigningAlg) {
        this.requestObjectSigningAlg = requestObjectSigningAlg;
    }

    public Client responseTypes(List<ResponseType> responseTypes) {

        this.responseTypes = responseTypes;
        return this;
    }

    public Client addresponseTypesItem(ResponseType responseTypesItem) {
        if (this.responseTypes == null) {
            this.responseTypes = new ArrayList<>();
        }
        this.responseTypes.add(responseTypesItem);
        return this;
    }

    /**
     * Array of OAuth 2.0 response type strings. Default value: &#x60;[code]&#x60;
     *
     * @return responseTypes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Array of OAuth 2.0 response type strings. Default value: `[code]`")
    @JsonProperty(JSON_PROPERTY_RESPONSE_TYPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<ResponseType> getResponseTypes() {
        return responseTypes;
    }

    @JsonProperty(JSON_PROPERTY_RESPONSE_TYPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setResponseTypes(List<ResponseType> responseTypes) {
        this.responseTypes = responseTypes;
    }

    public Client tokenEndpointAuthMethod(EndpointAuthMethod tokenEndpointAuthMethod) {

        this.tokenEndpointAuthMethod = tokenEndpointAuthMethod;
        return this;
    }

    /**
     * Get tokenEndpointAuthMethod
     *
     * @return tokenEndpointAuthMethod
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TOKEN_ENDPOINT_AUTH_METHOD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public EndpointAuthMethod getTokenEndpointAuthMethod() {
        return tokenEndpointAuthMethod;
    }

    @JsonProperty(JSON_PROPERTY_TOKEN_ENDPOINT_AUTH_METHOD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTokenEndpointAuthMethod(EndpointAuthMethod tokenEndpointAuthMethod) {
        this.tokenEndpointAuthMethod = tokenEndpointAuthMethod;
    }

    public Client tosUri(String tosUri) {
        this.tosUri = JsonNullable.<String> of(tosUri);

        return this;
    }

    /**
     * URL string of a web page providing the client&#39;s terms of service document
     *
     * @return tosUri
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "URL string of a web page providing the client's terms of service document")
    @JsonIgnore

    public String getTosUri() {
        return tosUri.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_TOS_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getTosUri_JsonNullable() {
        return tosUri;
    }

    @JsonProperty(JSON_PROPERTY_TOS_URI)
    public void setTosUri_JsonNullable(JsonNullable<String> tosUri) {
        this.tosUri = tosUri;
    }

    public void setTosUri(String tosUri) {
        this.tosUri = JsonNullable.<String> of(tosUri);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Client client = (Client) o;
        return Objects.equals(this.applicationType, client.applicationType)
                && Objects.equals(this.clientId, client.clientId)
                && Objects.equals(this.clientIdIssuedAt, client.clientIdIssuedAt)
                && Objects.equals(this.clientName, client.clientName)
                && equalsNullable(this.clientSecret, client.clientSecret)
                && equalsNullable(this.clientSecretExpiresAt, client.clientSecretExpiresAt)
                && Objects.equals(this.frontchannelLogoutSessionRequired, client.frontchannelLogoutSessionRequired)
                && equalsNullable(this.frontchannelLogoutUri, client.frontchannelLogoutUri)
                && Objects.equals(this.grantTypes, client.grantTypes)
                && Objects.equals(this.initiateLoginUri, client.initiateLoginUri)
                && Objects.equals(this.jwksUri, client.jwksUri) && equalsNullable(this.logoUri, client.logoUri)
                && equalsNullable(this.policyUri, client.policyUri)
                && Objects.equals(this.postLogoutRedirectUris, client.postLogoutRedirectUris)
                && Objects.equals(this.redirectUris, client.redirectUris)
                && Objects.equals(this.requestObjectSigningAlg, client.requestObjectSigningAlg)
                && Objects.equals(this.responseTypes, client.responseTypes)
                && Objects.equals(this.tokenEndpointAuthMethod, client.tokenEndpointAuthMethod)
                && equalsNullable(this.tosUri, client.tosUri);
        // ;
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b
                || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(applicationType, clientId, clientIdIssuedAt, clientName, hashCodeNullable(clientSecret),
                hashCodeNullable(clientSecretExpiresAt), frontchannelLogoutSessionRequired,
                hashCodeNullable(frontchannelLogoutUri), grantTypes, initiateLoginUri, jwksUri,
                hashCodeNullable(logoUri), hashCodeNullable(policyUri), postLogoutRedirectUris, redirectUris,
                requestObjectSigningAlg, responseTypes, tokenEndpointAuthMethod, hashCodeNullable(tosUri));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[] { a.get() }) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Client {\n");
        sb.append("    applicationType: ").append(toIndentedString(applicationType)).append("\n");
        sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
        sb.append("    clientIdIssuedAt: ").append(toIndentedString(clientIdIssuedAt)).append("\n");
        sb.append("    clientName: ").append(toIndentedString(clientName)).append("\n");
        sb.append("    clientSecret: ").append(toIndentedString(clientSecret)).append("\n");
        sb.append("    clientSecretExpiresAt: ").append(toIndentedString(clientSecretExpiresAt)).append("\n");
        sb.append("    frontchannelLogoutSessionRequired: ").append(toIndentedString(frontchannelLogoutSessionRequired))
                .append("\n");
        sb.append("    frontchannelLogoutUri: ").append(toIndentedString(frontchannelLogoutUri)).append("\n");
        sb.append("    grantTypes: ").append(toIndentedString(grantTypes)).append("\n");
        sb.append("    initiateLoginUri: ").append(toIndentedString(initiateLoginUri)).append("\n");
        sb.append("    jwksUri: ").append(toIndentedString(jwksUri)).append("\n");
        sb.append("    logoUri: ").append(toIndentedString(logoUri)).append("\n");
        sb.append("    policyUri: ").append(toIndentedString(policyUri)).append("\n");
        sb.append("    postLogoutRedirectUris: ").append(toIndentedString(postLogoutRedirectUris)).append("\n");
        sb.append("    redirectUris: ").append(toIndentedString(redirectUris)).append("\n");
        sb.append("    requestObjectSigningAlg: ").append(toIndentedString(requestObjectSigningAlg)).append("\n");
        sb.append("    responseTypes: ").append(toIndentedString(responseTypes)).append("\n");
        sb.append("    tokenEndpointAuthMethod: ").append(toIndentedString(tokenEndpointAuthMethod)).append("\n");
        sb.append("    tosUri: ").append(toIndentedString(tosUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
