package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Provides the status whether a domain has been failed over or not
 */
@ApiModel(description = "Provides the status whether a domain has been failed over or not")
@JsonPropertyOrder({ DRStatusItem.JSON_PROPERTY_DOMAIN, DRStatusItem.JSON_PROPERTY_IS_FAILED_OVER })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class DRStatusItem implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private String domain;

    public static final String JSON_PROPERTY_IS_FAILED_OVER = "isFailedOver";
    private Boolean isFailedOver;

    public DRStatusItem() {
    }

    public DRStatusItem domain(String domain) {

        this.domain = domain;
        return this;
    }

    /**
     * domain
     *
     * @return domain
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "domain")
    @JsonProperty(JSON_PROPERTY_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDomain() {
        return domain;
    }

    @JsonProperty(JSON_PROPERTY_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public DRStatusItem isFailedOver(Boolean isFailedOver) {

        this.isFailedOver = isFailedOver;
        return this;
    }

    /**
     * Indicates if the domain has been failed over
     *
     * @return isFailedOver
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates if the domain has been failed over")
    @JsonProperty(JSON_PROPERTY_IS_FAILED_OVER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getIsFailedOver() {
        return isFailedOver;
    }

    @JsonProperty(JSON_PROPERTY_IS_FAILED_OVER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIsFailedOver(Boolean isFailedOver) {
        this.isFailedOver = isFailedOver;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DRStatusItem drStatusItem = (DRStatusItem) o;
        return Objects.equals(this.domain, drStatusItem.domain)
                && Objects.equals(this.isFailedOver, drStatusItem.isFailedOver);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(domain, isFailedOver);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DRStatusItem {\n");
        sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
        sb.append("    isFailedOver: ").append(toIndentedString(isFailedOver)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
