package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LinksSelf;
import com.okta.sdk.resource.model.Platform;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * DeviceAssurance
 */
@JsonPropertyOrder({ DeviceAssurance.JSON_PROPERTY_CREATED_BY, DeviceAssurance.JSON_PROPERTY_CREATED_DATE,
        DeviceAssurance.JSON_PROPERTY_ID, DeviceAssurance.JSON_PROPERTY_LAST_UPDATE,
        DeviceAssurance.JSON_PROPERTY_LAST_UPDATED_BY, DeviceAssurance.JSON_PROPERTY_NAME,
        DeviceAssurance.JSON_PROPERTY_PLATFORM, DeviceAssurance.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "platform", visible = true, defaultImpl = DeviceAssurance.class)
@JsonSubTypes({ @JsonSubTypes.Type(value = DeviceAssuranceAndroidPlatform.class, name = "ANDROID"),
        @JsonSubTypes.Type(value = DeviceAssuranceChromeOSPlatform.class, name = "CHROMEOS"),
        @JsonSubTypes.Type(value = DeviceAssuranceIOSPlatform.class, name = "IOS"),
        @JsonSubTypes.Type(value = DeviceAssuranceMacOSPlatform.class, name = "MACOS"),
        @JsonSubTypes.Type(value = DeviceAssuranceWindowsPlatform.class, name = "WINDOWS"), })

public class DeviceAssurance implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREATED_BY = "createdBy";
    private String createdBy;

    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    private String createdDate;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    private String lastUpdate;

    public static final String JSON_PROPERTY_LAST_UPDATED_BY = "lastUpdatedBy";
    private String lastUpdatedBy;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_PLATFORM = "platform";
    protected Platform platform;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    public DeviceAssurance() {
    }

    /*
     * @JsonCreator public DeviceAssurance(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED_BY) String createdBy,
     *
     * @JsonProperty(JSON_PROPERTY_CREATED_DATE) String createdDate,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATE) String lastUpdate,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED_BY) String lastUpdatedBy ) { this(); this.createdBy = createdBy;
     * this.createdDate = createdDate; this.id = id; this.lastUpdate = lastUpdate; this.lastUpdatedBy = lastUpdatedBy; }
     */

    /**
     * Get createdBy
     *
     * @return createdBy
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CREATED_BY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCreatedBy() {
        return createdBy;
    }

    /**
     * Get createdDate
     *
     * @return createdDate
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CREATED_DATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCreatedDate() {
        return createdDate;
    }

    /**
     * Get id
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Get lastUpdate
     *
     * @return lastUpdate
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLastUpdate() {
        return lastUpdate;
    }

    /**
     * Get lastUpdatedBy
     *
     * @return lastUpdatedBy
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED_BY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLastUpdatedBy() {
        return lastUpdatedBy;
    }

    public DeviceAssurance name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Display name of the Device Assurance Policy
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Display name of the Device Assurance Policy")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public DeviceAssurance platform(Platform platform) {

        this.platform = platform;
        return this;
    }

    /**
     * Get platform
     *
     * @return platform
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PLATFORM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Platform getPlatform() {
        return platform;
    }

    @JsonProperty(JSON_PROPERTY_PLATFORM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public DeviceAssurance links(LinksSelf links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksSelf getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeviceAssurance deviceAssurance = (DeviceAssurance) o;
        return Objects.equals(this.createdBy, deviceAssurance.createdBy)
                && Objects.equals(this.createdDate, deviceAssurance.createdDate)
                && Objects.equals(this.id, deviceAssurance.id)
                && Objects.equals(this.lastUpdate, deviceAssurance.lastUpdate)
                && Objects.equals(this.lastUpdatedBy, deviceAssurance.lastUpdatedBy)
                && Objects.equals(this.name, deviceAssurance.name)
                && Objects.equals(this.platform, deviceAssurance.platform)
                && Objects.equals(this.links, deviceAssurance.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(createdBy, createdDate, id, lastUpdate, lastUpdatedBy, name, platform, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeviceAssurance {\n");
        sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
        sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
        sb.append("    lastUpdatedBy: ").append(toIndentedString(lastUpdatedBy)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    platform: ").append(toIndentedString(platform)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
