package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.DomainCertificateSourceType;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * DomainRequest
 */
@JsonPropertyOrder({ DomainRequest.JSON_PROPERTY_CERTIFICATE_SOURCE_TYPE, DomainRequest.JSON_PROPERTY_DOMAIN })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class DomainRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CERTIFICATE_SOURCE_TYPE = "certificateSourceType";
    private DomainCertificateSourceType certificateSourceType;

    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private String domain;

    public DomainRequest() {
    }

    public DomainRequest certificateSourceType(DomainCertificateSourceType certificateSourceType) {

        this.certificateSourceType = certificateSourceType;
        return this;
    }

    /**
     * Get certificateSourceType
     *
     * @return certificateSourceType
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_CERTIFICATE_SOURCE_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public DomainCertificateSourceType getCertificateSourceType() {
        return certificateSourceType;
    }

    @JsonProperty(JSON_PROPERTY_CERTIFICATE_SOURCE_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setCertificateSourceType(DomainCertificateSourceType certificateSourceType) {
        this.certificateSourceType = certificateSourceType;
    }

    public DomainRequest domain(String domain) {

        this.domain = domain;
        return this;
    }

    /**
     * Custom domain name
     *
     * @return domain
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "login.example.com", required = true, value = "Custom domain name")
    @JsonProperty(JSON_PROPERTY_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getDomain() {
        return domain;
    }

    @JsonProperty(JSON_PROPERTY_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DomainRequest domainRequest = (DomainRequest) o;
        return Objects.equals(this.certificateSourceType, domainRequest.certificateSourceType)
                && Objects.equals(this.domain, domainRequest.domain);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(certificateSourceType, domain);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DomainRequest {\n");
        sb.append("    certificateSourceType: ").append(toIndentedString(certificateSourceType)).append("\n");
        sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
