package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.EmailPreviewLinks;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * EmailPreview
 */
@JsonPropertyOrder({ EmailPreview.JSON_PROPERTY_BODY, EmailPreview.JSON_PROPERTY_SUBJECT,
        EmailPreview.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class EmailPreview implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_BODY = "body";
    private String body;

    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private String subject;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private EmailPreviewLinks links;

    public EmailPreview() {
    }

    /*
     * @JsonCreator public EmailPreview(
     *
     * @JsonProperty(JSON_PROPERTY_BODY) String body,
     *
     * @JsonProperty(JSON_PROPERTY_SUBJECT) String subject ) { this(); this.body = body; this.subject = subject; }
     */

    /**
     * The email&#39;s HTML body
     *
     * @return body
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The email's HTML body")
    @JsonProperty(JSON_PROPERTY_BODY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getBody() {
        return body;
    }

    /**
     * The email&#39;s subject
     *
     * @return subject
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The email's subject")
    @JsonProperty(JSON_PROPERTY_SUBJECT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getSubject() {
        return subject;
    }

    public EmailPreview links(EmailPreviewLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public EmailPreviewLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(EmailPreviewLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EmailPreview emailPreview = (EmailPreview) o;
        return Objects.equals(this.body, emailPreview.body) && Objects.equals(this.subject, emailPreview.subject)
                && Objects.equals(this.links, emailPreview.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(body, subject, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailPreview {\n");
        sb.append("    body: ").append(toIndentedString(body)).append("\n");
        sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
