package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Enrollment Initialization Response
 */
@ApiModel(description = "Enrollment Initialization Response")
@JsonPropertyOrder({ EnrollmentActivationResponse.JSON_PROPERTY_AUTHENTICATOR_ENROLLMENT_IDS,
        EnrollmentActivationResponse.JSON_PROPERTY_FULFILLMENT_PROVIDER,
        EnrollmentActivationResponse.JSON_PROPERTY_USER_ID })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class EnrollmentActivationResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AUTHENTICATOR_ENROLLMENT_IDS = "authenticatorEnrollmentIds";
    private List<String> authenticatorEnrollmentIds = null;

    /**
     * Name of the fulfillment provider for the WebAuthn Preregistration Factor
     */
    public enum FulfillmentProviderEnum {
        YUBICO("yubico"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        FulfillmentProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static FulfillmentProviderEnum fromValue(String value) {
            for (FulfillmentProviderEnum b : FulfillmentProviderEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_FULFILLMENT_PROVIDER = "fulfillmentProvider";
    private FulfillmentProviderEnum fulfillmentProvider;

    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;

    public EnrollmentActivationResponse() {
    }

    public EnrollmentActivationResponse authenticatorEnrollmentIds(List<String> authenticatorEnrollmentIds) {

        this.authenticatorEnrollmentIds = authenticatorEnrollmentIds;
        return this;
    }

    public EnrollmentActivationResponse addauthenticatorEnrollmentIdsItem(String authenticatorEnrollmentIdsItem) {
        if (this.authenticatorEnrollmentIds == null) {
            this.authenticatorEnrollmentIds = new ArrayList<>();
        }
        this.authenticatorEnrollmentIds.add(authenticatorEnrollmentIdsItem);
        return this;
    }

    /**
     * List of IDs for preregistered WebAuthn Factors in Okta
     *
     * @return authenticatorEnrollmentIds
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "List of IDs for preregistered WebAuthn Factors in Okta")
    @JsonProperty(JSON_PROPERTY_AUTHENTICATOR_ENROLLMENT_IDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getAuthenticatorEnrollmentIds() {
        return authenticatorEnrollmentIds;
    }

    @JsonProperty(JSON_PROPERTY_AUTHENTICATOR_ENROLLMENT_IDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticatorEnrollmentIds(List<String> authenticatorEnrollmentIds) {
        this.authenticatorEnrollmentIds = authenticatorEnrollmentIds;
    }

    public EnrollmentActivationResponse fulfillmentProvider(FulfillmentProviderEnum fulfillmentProvider) {

        this.fulfillmentProvider = fulfillmentProvider;
        return this;
    }

    /**
     * Name of the fulfillment provider for the WebAuthn Preregistration Factor
     *
     * @return fulfillmentProvider
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the fulfillment provider for the WebAuthn Preregistration Factor")
    @JsonProperty(JSON_PROPERTY_FULFILLMENT_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public FulfillmentProviderEnum getFulfillmentProvider() {
        return fulfillmentProvider;
    }

    @JsonProperty(JSON_PROPERTY_FULFILLMENT_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFulfillmentProvider(FulfillmentProviderEnum fulfillmentProvider) {
        this.fulfillmentProvider = fulfillmentProvider;
    }

    public EnrollmentActivationResponse userId(String userId) {

        this.userId = userId;
        return this;
    }

    /**
     * ID of an existing Okta user
     *
     * @return userId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "ID of an existing Okta user")
    @JsonProperty(JSON_PROPERTY_USER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUserId() {
        return userId;
    }

    @JsonProperty(JSON_PROPERTY_USER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EnrollmentActivationResponse enrollmentActivationResponse = (EnrollmentActivationResponse) o;
        return Objects.equals(this.authenticatorEnrollmentIds, enrollmentActivationResponse.authenticatorEnrollmentIds)
                && Objects.equals(this.fulfillmentProvider, enrollmentActivationResponse.fulfillmentProvider)
                && Objects.equals(this.userId, enrollmentActivationResponse.userId);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(authenticatorEnrollmentIds, fulfillmentProvider, userId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EnrollmentActivationResponse {\n");
        sb.append("    authenticatorEnrollmentIds: ").append(toIndentedString(authenticatorEnrollmentIds)).append("\n");
        sb.append("    fulfillmentProvider: ").append(toIndentedString(fulfillmentProvider)).append("\n");
        sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
