package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.WebAuthnCredRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Yubico Transport Key in the form of a JWK, used to encrypt our fulfillment request to Yubico. The currently agreed
 * protocol uses P-384.
 */
@ApiModel(description = "Yubico Transport Key in the form of a JWK, used to encrypt our fulfillment request to Yubico. The currently agreed protocol uses P-384.")
@JsonPropertyOrder({ EnrollmentInitializationResponse.JSON_PROPERTY_CRED_REQUESTS,
        EnrollmentInitializationResponse.JSON_PROPERTY_FULFILLMENT_PROVIDER,
        EnrollmentInitializationResponse.JSON_PROPERTY_PIN_REQUEST_JWE,
        EnrollmentInitializationResponse.JSON_PROPERTY_USER_ID })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class EnrollmentInitializationResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CRED_REQUESTS = "credRequests";
    private List<WebAuthnCredRequest> credRequests = null;

    /**
     * Name of the fulfillment provider for the WebAuthn Preregistration Factor
     */
    public enum FulfillmentProviderEnum {
        YUBICO("yubico"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        FulfillmentProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static FulfillmentProviderEnum fromValue(String value) {
            for (FulfillmentProviderEnum b : FulfillmentProviderEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_FULFILLMENT_PROVIDER = "fulfillmentProvider";
    private FulfillmentProviderEnum fulfillmentProvider;

    public static final String JSON_PROPERTY_PIN_REQUEST_JWE = "pinRequestJwe";
    private String pinRequestJwe;

    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;

    public EnrollmentInitializationResponse() {
    }

    public EnrollmentInitializationResponse credRequests(List<WebAuthnCredRequest> credRequests) {

        this.credRequests = credRequests;
        return this;
    }

    public EnrollmentInitializationResponse addcredRequestsItem(WebAuthnCredRequest credRequestsItem) {
        if (this.credRequests == null) {
            this.credRequests = new ArrayList<>();
        }
        this.credRequests.add(credRequestsItem);
        return this;
    }

    /**
     * List of credential requests for the fulfillment provider
     *
     * @return credRequests
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "List of credential requests for the fulfillment provider")
    @JsonProperty(JSON_PROPERTY_CRED_REQUESTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<WebAuthnCredRequest> getCredRequests() {
        return credRequests;
    }

    @JsonProperty(JSON_PROPERTY_CRED_REQUESTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCredRequests(List<WebAuthnCredRequest> credRequests) {
        this.credRequests = credRequests;
    }

    public EnrollmentInitializationResponse fulfillmentProvider(FulfillmentProviderEnum fulfillmentProvider) {

        this.fulfillmentProvider = fulfillmentProvider;
        return this;
    }

    /**
     * Name of the fulfillment provider for the WebAuthn Preregistration Factor
     *
     * @return fulfillmentProvider
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the fulfillment provider for the WebAuthn Preregistration Factor")
    @JsonProperty(JSON_PROPERTY_FULFILLMENT_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public FulfillmentProviderEnum getFulfillmentProvider() {
        return fulfillmentProvider;
    }

    @JsonProperty(JSON_PROPERTY_FULFILLMENT_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFulfillmentProvider(FulfillmentProviderEnum fulfillmentProvider) {
        this.fulfillmentProvider = fulfillmentProvider;
    }

    public EnrollmentInitializationResponse pinRequestJwe(String pinRequestJwe) {

        this.pinRequestJwe = pinRequestJwe;
        return this;
    }

    /**
     * Encrypted JWE of PIN request for the fulfillment provider
     *
     * @return pinRequestJwe
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Encrypted JWE of PIN request for the fulfillment provider")
    @JsonProperty(JSON_PROPERTY_PIN_REQUEST_JWE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPinRequestJwe() {
        return pinRequestJwe;
    }

    @JsonProperty(JSON_PROPERTY_PIN_REQUEST_JWE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPinRequestJwe(String pinRequestJwe) {
        this.pinRequestJwe = pinRequestJwe;
    }

    public EnrollmentInitializationResponse userId(String userId) {

        this.userId = userId;
        return this;
    }

    /**
     * ID of an existing Okta user
     *
     * @return userId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "ID of an existing Okta user")
    @JsonProperty(JSON_PROPERTY_USER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUserId() {
        return userId;
    }

    @JsonProperty(JSON_PROPERTY_USER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EnrollmentInitializationResponse enrollmentInitializationResponse = (EnrollmentInitializationResponse) o;
        return Objects.equals(this.credRequests, enrollmentInitializationResponse.credRequests)
                && Objects.equals(this.fulfillmentProvider, enrollmentInitializationResponse.fulfillmentProvider)
                && Objects.equals(this.pinRequestJwe, enrollmentInitializationResponse.pinRequestJwe)
                && Objects.equals(this.userId, enrollmentInitializationResponse.userId);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(credRequests, fulfillmentProvider, pinRequestJwe, userId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EnrollmentInitializationResponse {\n");
        sb.append("    credRequests: ").append(toIndentedString(credRequests)).append("\n");
        sb.append("    fulfillmentProvider: ").append(toIndentedString(fulfillmentProvider)).append("\n");
        sb.append("    pinRequestJwe: ").append(toIndentedString(pinRequestJwe)).append("\n");
        sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
