package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.GroupRuleExpression;
import com.okta.sdk.resource.model.GroupRulePeopleCondition;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Defines group rule conditions
 */
@ApiModel(description = "Defines group rule conditions")
@JsonPropertyOrder({ GroupRuleConditions.JSON_PROPERTY_EXPRESSION, GroupRuleConditions.JSON_PROPERTY_PEOPLE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class GroupRuleConditions implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EXPRESSION = "expression";
    private GroupRuleExpression expression;

    public static final String JSON_PROPERTY_PEOPLE = "people";
    private GroupRulePeopleCondition people;

    public GroupRuleConditions() {
    }

    public GroupRuleConditions expression(GroupRuleExpression expression) {

        this.expression = expression;
        return this;
    }

    /**
     * Get expression
     *
     * @return expression
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_EXPRESSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public GroupRuleExpression getExpression() {
        return expression;
    }

    @JsonProperty(JSON_PROPERTY_EXPRESSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setExpression(GroupRuleExpression expression) {
        this.expression = expression;
    }

    public GroupRuleConditions people(GroupRulePeopleCondition people) {

        this.people = people;
        return this;
    }

    /**
     * Get people
     *
     * @return people
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PEOPLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public GroupRulePeopleCondition getPeople() {
        return people;
    }

    @JsonProperty(JSON_PROPERTY_PEOPLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPeople(GroupRulePeopleCondition people) {
        this.people = people;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GroupRuleConditions groupRuleConditions = (GroupRuleConditions) o;
        return Objects.equals(this.expression, groupRuleConditions.expression)
                && Objects.equals(this.people, groupRuleConditions.people);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(expression, people);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupRuleConditions {\n");
        sb.append("    expression: ").append(toIndentedString(expression)).append("\n");
        sb.append("    people: ").append(toIndentedString(people)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
