package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.GroupSchemaAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * All custom Profile properties are defined in a Profile subschema with the resolution scope &#x60;#custom&#x60;
 */
@ApiModel(description = "All custom Profile properties are defined in a Profile subschema with the resolution scope `#custom`")
@JsonPropertyOrder({ GroupSchemaCustom.JSON_PROPERTY_ID, GroupSchemaCustom.JSON_PROPERTY_PROPERTIES,
        GroupSchemaCustom.JSON_PROPERTY_REQUIRED, GroupSchemaCustom.JSON_PROPERTY_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class GroupSchemaCustom implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_PROPERTIES = "properties";
    private Map<String, GroupSchemaAttribute> properties = null;

    public static final String JSON_PROPERTY_REQUIRED = "required";
    private List<String> required = null;

    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public GroupSchemaCustom() {
    }

    /*
     * @JsonCreator public GroupSchemaCustom(
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_REQUIRED) List<String> required,
     *
     * @JsonProperty(JSON_PROPERTY_TYPE) String type ) { this(); this.id = id; this.required = required; this.type =
     * type; }
     */

    /**
     * The subschema name
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The subschema name")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    public GroupSchemaCustom properties(Map<String, GroupSchemaAttribute> properties) {

        this.properties = properties;
        return this;
    }

    public GroupSchemaCustom putpropertiesItem(String key, GroupSchemaAttribute propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    /**
     * The &#x60;#custom&#x60; object properties
     *
     * @return properties
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The `#custom` object properties")
    @JsonProperty(JSON_PROPERTY_PROPERTIES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, GroupSchemaAttribute> getProperties() {
        return properties;
    }

    @JsonProperty(JSON_PROPERTY_PROPERTIES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProperties(Map<String, GroupSchemaAttribute> properties) {
        this.properties = properties;
    }

    /**
     * A collection indicating required property names
     *
     * @return required
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A collection indicating required property names")
    @JsonProperty(JSON_PROPERTY_REQUIRED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getRequired() {
        return required;
    }

    /**
     * The object type
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The object type")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getType() {
        return type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GroupSchemaCustom groupSchemaCustom = (GroupSchemaCustom) o;
        return Objects.equals(this.id, groupSchemaCustom.id)
                && Objects.equals(this.properties, groupSchemaCustom.properties)
                && Objects.equals(this.required, groupSchemaCustom.required)
                && Objects.equals(this.type, groupSchemaCustom.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, properties, required, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupSchemaCustom {\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
        sb.append("    required: ").append(toIndentedString(required)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
