package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.CsrPublishHrefHints;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Link to publish CSR
 */
@ApiModel(description = "Link to publish CSR")
@JsonPropertyOrder({ HrefCsrPublishLink.JSON_PROPERTY_HINTS, HrefCsrPublishLink.JSON_PROPERTY_HREF })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class HrefCsrPublishLink implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_HINTS = "hints";
    private CsrPublishHrefHints hints;

    public static final String JSON_PROPERTY_HREF = "href";
    private String href;

    public HrefCsrPublishLink() {
    }

    public HrefCsrPublishLink hints(CsrPublishHrefHints hints) {

        this.hints = hints;
        return this;
    }

    /**
     * Get hints
     *
     * @return hints
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_HINTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public CsrPublishHrefHints getHints() {
        return hints;
    }

    @JsonProperty(JSON_PROPERTY_HINTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setHints(CsrPublishHrefHints hints) {
        this.hints = hints;
    }

    public HrefCsrPublishLink href(String href) {

        this.href = href;
        return this;
    }

    /**
     * Link URI
     *
     * @return href
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "https://{yourOktaDomain}/api/v1/apps/0oad5lTSBOMUBOBVVQSC/credentials/csrs/h9zkutaSe7fZX0SwN1GqDApofgD1OW8g2B5l2azha50/lifecycle/publish", required = true, value = "Link URI")
    @JsonProperty(JSON_PROPERTY_HREF)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getHref() {
        return href;
    }

    @JsonProperty(JSON_PROPERTY_HREF)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setHref(String href) {
        this.href = href;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrefCsrPublishLink hrefCsrPublishLink = (HrefCsrPublishLink) o;
        return Objects.equals(this.hints, hrefCsrPublishLink.hints)
                && Objects.equals(this.href, hrefCsrPublishLink.href);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(hints, href);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HrefCsrPublishLink {\n");
        sb.append("    hints: ").append(toIndentedString(hints)).append("\n");
        sb.append("    href: ").append(toIndentedString(href)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
