package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.IdentitySourceSessionStatus;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * IdentitySourceSession
 */
@JsonPropertyOrder({ IdentitySourceSession.JSON_PROPERTY_CREATED, IdentitySourceSession.JSON_PROPERTY_ID,
        IdentitySourceSession.JSON_PROPERTY_IDENTITY_SOURCE_ID, IdentitySourceSession.JSON_PROPERTY_IMPORT_TYPE,
        IdentitySourceSession.JSON_PROPERTY_LAST_UPDATED, IdentitySourceSession.JSON_PROPERTY_STATUS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class IdentitySourceSession implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_IDENTITY_SOURCE_ID = "identitySourceId";
    private String identitySourceId;

    public static final String JSON_PROPERTY_IMPORT_TYPE = "importType";
    private String importType;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_STATUS = "status";
    private IdentitySourceSessionStatus status;

    public IdentitySourceSession() {
    }

    /*
     * @JsonCreator public IdentitySourceSession(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_IDENTITY_SOURCE_ID) String identitySourceId,
     *
     * @JsonProperty(JSON_PROPERTY_IMPORT_TYPE) String importType,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated ) { this(); this.created = created; this.id
     * = id; this.identitySourceId = identitySourceId; this.importType = importType; this.lastUpdated = lastUpdated; }
     */

    /**
     * The timestamp when the Identity Source Session was created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The timestamp when the Identity Source Session was created")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    /**
     * The ID of the Identity Source Session
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The ID of the Identity Source Session")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * The ID of the custom Identity Source for which the session is created
     *
     * @return identitySourceId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The ID of the custom Identity Source for which the session is created")
    @JsonProperty(JSON_PROPERTY_IDENTITY_SOURCE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getIdentitySourceId() {
        return identitySourceId;
    }

    /**
     * The type of import. All imports are &#x60;INCREMENTAL&#x60; imports.
     *
     * @return importType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The type of import.  All imports are `INCREMENTAL` imports.")
    @JsonProperty(JSON_PROPERTY_IMPORT_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getImportType() {
        return importType;
    }

    /**
     * The timestamp when the Identity Source Session was created
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The timestamp when the Identity Source Session was created")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    public IdentitySourceSession status(IdentitySourceSessionStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public IdentitySourceSessionStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(IdentitySourceSessionStatus status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IdentitySourceSession identitySourceSession = (IdentitySourceSession) o;
        return Objects.equals(this.created, identitySourceSession.created)
                && Objects.equals(this.id, identitySourceSession.id)
                && Objects.equals(this.identitySourceId, identitySourceSession.identitySourceId)
                && Objects.equals(this.importType, identitySourceSession.importType)
                && Objects.equals(this.lastUpdated, identitySourceSession.lastUpdated)
                && Objects.equals(this.status, identitySourceSession.status);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(created, id, identitySourceId, importType, lastUpdated, status);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentitySourceSession {\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    identitySourceId: ").append(toIndentedString(identitySourceId)).append("\n");
        sb.append("    importType: ").append(toIndentedString(importType)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
