package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * LogOutcome
 */
@JsonPropertyOrder({ LogOutcome.JSON_PROPERTY_REASON, LogOutcome.JSON_PROPERTY_RESULT })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class LogOutcome implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_REASON = "reason";
    private String reason;

    /**
     * Result of the action
     */
    public enum ResultEnum {
        SUCCESS("SUCCESS"),

        FAILURE("FAILURE"),

        SKIPPED("SKIPPED"),

        ALLOW("ALLOW"),

        DENY("DENY"),

        CHALLENGE("CHALLENGE"),

        UNKNOWN("UNKNOWN"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        ResultEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static ResultEnum fromValue(String value) {
            for (ResultEnum b : ResultEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_RESULT = "result";
    private ResultEnum result;

    public LogOutcome() {
    }

    /*
     * @JsonCreator public LogOutcome(
     *
     * @JsonProperty(JSON_PROPERTY_REASON) String reason,
     *
     * @JsonProperty(JSON_PROPERTY_RESULT) ResultEnum result ) { this(); this.reason = reason; this.result = result; }
     */

    /**
     * Reason for the result, for example, &#x60;INVALID_CREDENTIALS&#x60;
     *
     * @return reason
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Reason for the result, for example, `INVALID_CREDENTIALS`")
    @JsonProperty(JSON_PROPERTY_REASON)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getReason() {
        return reason;
    }

    /**
     * Result of the action
     *
     * @return result
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Result of the action")
    @JsonProperty(JSON_PROPERTY_RESULT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ResultEnum getResult() {
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogOutcome logOutcome = (LogOutcome) o;
        return Objects.equals(this.reason, logOutcome.reason) && Objects.equals(this.result, logOutcome.result);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(reason, result);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogOutcome {\n");
        sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
        sb.append("    result: ").append(toIndentedString(result)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
