package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Specifies the streaming provider used Supported providers: * &#x60;aws_eventbridge&#x60; ([AWS
 * EventBridge](https://aws.amazon.com/eventbridge)) * &#x60;splunk_cloud_logstreaming&#x60; ([Splunk
 * Cloud](https://www.splunk.com/en_us/software/splunk-cloud-platform.html)) Select the provider type to see
 * provider-specific configurations in the &#x60;settings&#x60; property:
 */
public enum LogStreamType {

    AWS_EVENTBRIDGE("aws_eventbridge"),

    SPLUNK_CLOUD_LOGSTREAMING("splunk_cloud_logstreaming"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    LogStreamType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static LogStreamType fromValue(String value) {
        for (LogStreamType b : LogStreamType.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
