package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OAuthClientSecretLinks;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * OAuth2ClientSecret
 */
@JsonPropertyOrder({ OAuth2ClientSecret.JSON_PROPERTY_CLIENT_SECRET, OAuth2ClientSecret.JSON_PROPERTY_CREATED,
        OAuth2ClientSecret.JSON_PROPERTY_ID, OAuth2ClientSecret.JSON_PROPERTY_LAST_UPDATED,
        OAuth2ClientSecret.JSON_PROPERTY_SECRET_HASH, OAuth2ClientSecret.JSON_PROPERTY_STATUS,
        OAuth2ClientSecret.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class OAuth2ClientSecret implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CLIENT_SECRET = "client_secret";
    private String clientSecret;

    public static final String JSON_PROPERTY_CREATED = "created";
    private String created;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private String lastUpdated;

    public static final String JSON_PROPERTY_SECRET_HASH = "secret_hash";
    private String secretHash;

    /**
     * Status of the OAuth 2.0 Client Secret
     */
    public enum StatusEnum {
        ACTIVE("ACTIVE"),

        INACTIVE("INACTIVE"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status = StatusEnum.ACTIVE;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private OAuthClientSecretLinks links;

    public OAuth2ClientSecret() {
    }

    /*
     * @JsonCreator public OAuth2ClientSecret(
     *
     * @JsonProperty(JSON_PROPERTY_CLIENT_SECRET) String clientSecret,
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) String created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) String lastUpdated,
     *
     * @JsonProperty(JSON_PROPERTY_SECRET_HASH) String secretHash ) { this(); this.clientSecret = clientSecret;
     * this.created = created; this.id = id; this.lastUpdated = lastUpdated; this.secretHash = secretHash; }
     */

    /**
     * The OAuth 2.0 client secret string
     *
     * @return clientSecret
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "DRUFXGF9XbLn......a3x3POBiIxDreBCdZuFs5B", value = "The OAuth 2.0 client secret string")
    @JsonProperty(JSON_PROPERTY_CLIENT_SECRET)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getClientSecret() {
        return clientSecret;
    }

    /**
     * Timestamp when the OAuth Client 2.0 Secret was created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2023-02-21T20:08:24.000Z", value = "Timestamp when the OAuth Client 2.0 Secret was created")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCreated() {
        return created;
    }

    /**
     * The unique ID of the OAuth Client Secret
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "ocs2f4zrZbs8nUa7p0g4", value = "The unique ID of the OAuth Client Secret")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Timestamp when the OAuth Client 2.0 Secret was updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2023-02-21T20:08:24.000Z", value = "Timestamp when the OAuth Client 2.0 Secret was updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLastUpdated() {
        return lastUpdated;
    }

    /**
     * OAuth 2.0 client secret string hash
     *
     * @return secretHash
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "yk4SVx4sUWVJVbHt6M-UPA", value = "OAuth 2.0 client secret string hash")
    @JsonProperty(JSON_PROPERTY_SECRET_HASH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getSecretHash() {
        return secretHash;
    }

    public OAuth2ClientSecret status(StatusEnum status) {

        this.status = status;
        return this;
    }

    /**
     * Status of the OAuth 2.0 Client Secret
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "ACTIVE", value = "Status of the OAuth 2.0 Client Secret")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public StatusEnum getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public OAuth2ClientSecret links(OAuthClientSecretLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OAuthClientSecretLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(OAuthClientSecretLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OAuth2ClientSecret oauth2ClientSecret = (OAuth2ClientSecret) o;
        return Objects.equals(this.clientSecret, oauth2ClientSecret.clientSecret)
                && Objects.equals(this.created, oauth2ClientSecret.created)
                && Objects.equals(this.id, oauth2ClientSecret.id)
                && Objects.equals(this.lastUpdated, oauth2ClientSecret.lastUpdated)
                && Objects.equals(this.secretHash, oauth2ClientSecret.secretHash)
                && Objects.equals(this.status, oauth2ClientSecret.status)
                && Objects.equals(this.links, oauth2ClientSecret.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientSecret, created, id, lastUpdated, secretHash, status, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2ClientSecret {\n");
        sb.append("    clientSecret: ").append(toIndentedString(clientSecret)).append("\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    secretHash: ").append(toIndentedString(secretHash)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
