package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ProtocolEndpointBinding;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Endpoint for an [OAuth 2.0 Authorization Server (AS)](https://tools.ietf.org/html/rfc6749#page-18)
 */
@ApiModel(description = "Endpoint for an [OAuth 2.0 Authorization Server (AS)](https://tools.ietf.org/html/rfc6749#page-18)")
@JsonPropertyOrder({ OAuthAuthorizationEndpoint.JSON_PROPERTY_BINDING, OAuthAuthorizationEndpoint.JSON_PROPERTY_URL })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class OAuthAuthorizationEndpoint implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_BINDING = "binding";
    private ProtocolEndpointBinding binding;

    public static final String JSON_PROPERTY_URL = "url";
    private String url;

    public OAuthAuthorizationEndpoint() {
    }

    public OAuthAuthorizationEndpoint binding(ProtocolEndpointBinding binding) {

        this.binding = binding;
        return this;
    }

    /**
     * Get binding
     *
     * @return binding
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_BINDING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProtocolEndpointBinding getBinding() {
        return binding;
    }

    @JsonProperty(JSON_PROPERTY_BINDING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setBinding(ProtocolEndpointBinding binding) {
        this.binding = binding;
    }

    public OAuthAuthorizationEndpoint url(String url) {

        this.url = url;
        return this;
    }

    /**
     * URL of the IdP Authorization Server (AS) authorization endpoint
     *
     * @return url
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "https://idp.example.com/authorize", value = "URL of the IdP Authorization Server (AS) authorization endpoint")
    @JsonProperty(JSON_PROPERTY_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUrl() {
        return url;
    }

    @JsonProperty(JSON_PROPERTY_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OAuthAuthorizationEndpoint oauthAuthorizationEndpoint = (OAuthAuthorizationEndpoint) o;
        return Objects.equals(this.binding, oauthAuthorizationEndpoint.binding)
                && Objects.equals(this.url, oauthAuthorizationEndpoint.url);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(binding, url);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuthAuthorizationEndpoint {\n");
        sb.append("    binding: ").append(toIndentedString(binding)).append("\n");
        sb.append("    url: ").append(toIndentedString(url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
