package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * &lt;div class&#x3D;\&quot;x-lifecycle-container\&quot;&gt;&lt;x-lifecycle
 * class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt;&lt;/div&gt;Contains the necessary properties for a dynamic
 * version requirement
 */
@ApiModel(description = "<div class=\"x-lifecycle-container\"><x-lifecycle class=\"ea\"></x-lifecycle></div>Contains the necessary properties for a dynamic version requirement")
@JsonPropertyOrder({ OSVersionDynamicVersionRequirement.JSON_PROPERTY_TYPE,
        OSVersionDynamicVersionRequirement.JSON_PROPERTY_DISTANCE_FROM_LATEST_MAJOR,
        OSVersionDynamicVersionRequirement.JSON_PROPERTY_LATEST_SECURITY_PATCH })
@JsonTypeName("OSVersion_dynamicVersionRequirement")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class OSVersionDynamicVersionRequirement implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Indicates the type of the dynamic OS version requirement
     */
    public enum TypeEnum {
        MINIMUM("MINIMUM"),

        EXACT("EXACT"),

        EXACT_ANY_SUPPORTED("EXACT_ANY_SUPPORTED"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public static final String JSON_PROPERTY_DISTANCE_FROM_LATEST_MAJOR = "distanceFromLatestMajor";
    private Integer distanceFromLatestMajor;

    public static final String JSON_PROPERTY_LATEST_SECURITY_PATCH = "latestSecurityPatch";
    private Boolean latestSecurityPatch;

    public OSVersionDynamicVersionRequirement() {
    }

    public OSVersionDynamicVersionRequirement type(TypeEnum type) {

        this.type = type;
        return this;
    }

    /**
     * Indicates the type of the dynamic OS version requirement
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates the type of the dynamic OS version requirement")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TypeEnum getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public OSVersionDynamicVersionRequirement distanceFromLatestMajor(Integer distanceFromLatestMajor) {

        this.distanceFromLatestMajor = distanceFromLatestMajor;
        return this;
    }

    /**
     * Indicates the distance from the latest major version minimum: 0 maximum: 1
     *
     * @return distanceFromLatestMajor
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates the distance from the latest major version")
    @JsonProperty(JSON_PROPERTY_DISTANCE_FROM_LATEST_MAJOR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getDistanceFromLatestMajor() {
        return distanceFromLatestMajor;
    }

    @JsonProperty(JSON_PROPERTY_DISTANCE_FROM_LATEST_MAJOR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDistanceFromLatestMajor(Integer distanceFromLatestMajor) {
        this.distanceFromLatestMajor = distanceFromLatestMajor;
    }

    public OSVersionDynamicVersionRequirement latestSecurityPatch(Boolean latestSecurityPatch) {

        this.latestSecurityPatch = latestSecurityPatch;
        return this;
    }

    /**
     * Indicates whether the device needs to be on the latest security patch
     *
     * @return latestSecurityPatch
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates whether the device needs to be on the latest security patch")
    @JsonProperty(JSON_PROPERTY_LATEST_SECURITY_PATCH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getLatestSecurityPatch() {
        return latestSecurityPatch;
    }

    @JsonProperty(JSON_PROPERTY_LATEST_SECURITY_PATCH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLatestSecurityPatch(Boolean latestSecurityPatch) {
        this.latestSecurityPatch = latestSecurityPatch;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OSVersionDynamicVersionRequirement osVersionDynamicVersionRequirement = (OSVersionDynamicVersionRequirement) o;
        return Objects.equals(this.type, osVersionDynamicVersionRequirement.type)
                && Objects.equals(this.distanceFromLatestMajor,
                        osVersionDynamicVersionRequirement.distanceFromLatestMajor)
                && Objects.equals(this.latestSecurityPatch, osVersionDynamicVersionRequirement.latestSecurityPatch);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, distanceFromLatestMajor, latestSecurityPatch);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OSVersionDynamicVersionRequirement {\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    distanceFromLatestMajor: ").append(toIndentedString(distanceFromLatestMajor)).append("\n");
        sb.append("    latestSecurityPatch: ").append(toIndentedString(latestSecurityPatch)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
