package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Settings required for the Microsoft Office 365 Provisioning Connection
 */
@ApiModel(description = "Settings required for the Microsoft Office 365 Provisioning Connection")
@JsonPropertyOrder({ Office365ProvisioningSettings.JSON_PROPERTY_ADMIN_PASSWORD,
        Office365ProvisioningSettings.JSON_PROPERTY_ADMIN_USERNAME })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class Office365ProvisioningSettings implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ADMIN_PASSWORD = "adminPassword";
    private String adminPassword;

    public static final String JSON_PROPERTY_ADMIN_USERNAME = "adminUsername";
    private String adminUsername;

    public Office365ProvisioningSettings() {
    }

    public Office365ProvisioningSettings adminPassword(String adminPassword) {

        this.adminPassword = adminPassword;
        return this;
    }

    /**
     * Microsoft Office 365 global administrator password
     *
     * @return adminPassword
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Microsoft Office 365 global administrator password")
    @JsonProperty(JSON_PROPERTY_ADMIN_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getAdminPassword() {
        return adminPassword;
    }

    @JsonProperty(JSON_PROPERTY_ADMIN_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public Office365ProvisioningSettings adminUsername(String adminUsername) {

        this.adminUsername = adminUsername;
        return this;
    }

    /**
     * Microsoft Office 365 global administrator username
     *
     * @return adminUsername
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Microsoft Office 365 global administrator username")
    @JsonProperty(JSON_PROPERTY_ADMIN_USERNAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getAdminUsername() {
        return adminUsername;
    }

    @JsonProperty(JSON_PROPERTY_ADMIN_USERNAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Office365ProvisioningSettings office365ProvisioningSettings = (Office365ProvisioningSettings) o;
        return Objects.equals(this.adminPassword, office365ProvisioningSettings.adminPassword)
                && Objects.equals(this.adminUsername, office365ProvisioningSettings.adminUsername);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(adminPassword, adminUsername);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Office365ProvisioningSettings {\n");
        sb.append("    adminPassword: ").append(toIndentedString(adminPassword)).append("\n");
        sb.append("    adminUsername: ").append(toIndentedString(adminUsername)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
