package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * OIDC configuration details
 */
@ApiModel(description = "OIDC configuration details")
@JsonPropertyOrder({ Oidc.JSON_PROPERTY_DOC, Oidc.JSON_PROPERTY_INITIATE_LOGIN_URI, Oidc.JSON_PROPERTY_POST_LOGOUT_URIS,
        Oidc.JSON_PROPERTY_REDIRECT_URIS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class Oidc implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DOC = "doc";
    private URI doc;

    public static final String JSON_PROPERTY_INITIATE_LOGIN_URI = "initiateLoginUri";
    private URI initiateLoginUri;

    public static final String JSON_PROPERTY_POST_LOGOUT_URIS = "postLogoutUris";
    private List<URI> postLogoutUris = null;

    public static final String JSON_PROPERTY_REDIRECT_URIS = "redirectUris";
    private List<URI> redirectUris = new ArrayList<>();

    public Oidc() {
    }

    public Oidc doc(URI doc) {

        this.doc = doc;
        return this;
    }

    /**
     * The URL to your customer-facing instructions for configuring your OIDC integration. See [Customer configuration
     * document
     * guidelines](https://developer.okta.com/docs/guides/submit-app-prereq/main/#customer-configuration-document-guidelines).
     *
     * @return doc
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "https://example.com/strawberry/help/oidcSetup", required = true, value = "The URL to your customer-facing instructions for configuring your OIDC integration. See [Customer configuration document guidelines](https://developer.okta.com/docs/guides/submit-app-prereq/main/#customer-configuration-document-guidelines).")
    @JsonProperty(JSON_PROPERTY_DOC)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public URI getDoc() {
        return doc;
    }

    @JsonProperty(JSON_PROPERTY_DOC)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setDoc(URI doc) {
        this.doc = doc;
    }

    public Oidc initiateLoginUri(URI initiateLoginUri) {

        this.initiateLoginUri = initiateLoginUri;
        return this;
    }

    /**
     * The URL to redirect users when they click on your app from their Okta End-User Dashboard
     *
     * @return initiateLoginUri
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "https://${org.subdomain}.example.com/strawberry/oidc/sp-init", value = "The URL to redirect users when they click on your app from their Okta End-User Dashboard")
    @JsonProperty(JSON_PROPERTY_INITIATE_LOGIN_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public URI getInitiateLoginUri() {
        return initiateLoginUri;
    }

    @JsonProperty(JSON_PROPERTY_INITIATE_LOGIN_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setInitiateLoginUri(URI initiateLoginUri) {
        this.initiateLoginUri = initiateLoginUri;
    }

    public Oidc postLogoutUris(List<URI> postLogoutUris) {

        this.postLogoutUris = postLogoutUris;
        return this;
    }

    public Oidc addpostLogoutUrisItem(URI postLogoutUrisItem) {
        if (this.postLogoutUris == null) {
            this.postLogoutUris = new ArrayList<>();
        }
        this.postLogoutUris.add(postLogoutUrisItem);
        return this;
    }

    /**
     * The sign-out redirect URIs for your app. You can send a request to &#x60;/v1/logout&#x60; to sign the user out
     * and redirect them to one of these URIs.
     *
     * @return postLogoutUris
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The sign-out redirect URIs for your app. You can send a request to `/v1/logout` to sign the user out and redirect them to one of these URIs.")
    @JsonProperty(JSON_PROPERTY_POST_LOGOUT_URIS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<URI> getPostLogoutUris() {
        return postLogoutUris;
    }

    @JsonProperty(JSON_PROPERTY_POST_LOGOUT_URIS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPostLogoutUris(List<URI> postLogoutUris) {
        this.postLogoutUris = postLogoutUris;
    }

    public Oidc redirectUris(List<URI> redirectUris) {

        this.redirectUris = redirectUris;
        return this;
    }

    public Oidc addredirectUrisItem(URI redirectUrisItem) {
        if (this.redirectUris == null) {
            this.redirectUris = new ArrayList<>();
        }
        this.redirectUris.add(redirectUrisItem);
        return this;
    }

    /**
     * List of sign-in redirect URIs
     *
     * @return redirectUris
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "List of sign-in redirect URIs")
    @JsonProperty(JSON_PROPERTY_REDIRECT_URIS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public List<URI> getRedirectUris() {
        return redirectUris;
    }

    @JsonProperty(JSON_PROPERTY_REDIRECT_URIS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setRedirectUris(List<URI> redirectUris) {
        this.redirectUris = redirectUris;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Oidc oidc = (Oidc) o;
        return Objects.equals(this.doc, oidc.doc) && Objects.equals(this.initiateLoginUri, oidc.initiateLoginUri)
                && Objects.equals(this.postLogoutUris, oidc.postLogoutUris)
                && Objects.equals(this.redirectUris, oidc.redirectUris);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(doc, initiateLoginUri, postLogoutUris, redirectUris);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Oidc {\n");
        sb.append("    doc: ").append(toIndentedString(doc)).append("\n");
        sb.append("    initiateLoginUri: ").append(toIndentedString(initiateLoginUri)).append("\n");
        sb.append("    postLogoutUris: ").append(toIndentedString(postLogoutUris)).append("\n");
        sb.append("    redirectUris: ").append(toIndentedString(redirectUris)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
