package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Defines a list of Okta Personal settings that can be enabled or disabled for the org
 */
@ApiModel(description = "Defines a list of Okta Personal settings that can be enabled or disabled for the org")
@JsonPropertyOrder({ OktaPersonalAdminFeatureSettings.JSON_PROPERTY_ENABLE_ENDUSER_ENTRY_POINTS,
        OktaPersonalAdminFeatureSettings.JSON_PROPERTY_ENABLE_EXPORT_APPS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class OktaPersonalAdminFeatureSettings implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ENABLE_ENDUSER_ENTRY_POINTS = "enableEnduserEntryPoints";
    private Boolean enableEnduserEntryPoints;

    public static final String JSON_PROPERTY_ENABLE_EXPORT_APPS = "enableExportApps";
    private Boolean enableExportApps;

    public OktaPersonalAdminFeatureSettings() {
    }

    public OktaPersonalAdminFeatureSettings enableEnduserEntryPoints(Boolean enableEnduserEntryPoints) {

        this.enableEnduserEntryPoints = enableEnduserEntryPoints;
        return this;
    }

    /**
     * Allow entry points for an Okta Personal account in a Workforce org
     *
     * @return enableEnduserEntryPoints
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Allow entry points for an Okta Personal account in a Workforce org")
    @JsonProperty(JSON_PROPERTY_ENABLE_ENDUSER_ENTRY_POINTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getEnableEnduserEntryPoints() {
        return enableEnduserEntryPoints;
    }

    @JsonProperty(JSON_PROPERTY_ENABLE_ENDUSER_ENTRY_POINTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEnableEnduserEntryPoints(Boolean enableEnduserEntryPoints) {
        this.enableEnduserEntryPoints = enableEnduserEntryPoints;
    }

    public OktaPersonalAdminFeatureSettings enableExportApps(Boolean enableExportApps) {

        this.enableExportApps = enableExportApps;
        return this;
    }

    /**
     * Allow users to migrate apps from a Workforce account to an Okta Personal account
     *
     * @return enableExportApps
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Allow users to migrate apps from a Workforce account to an Okta Personal account")
    @JsonProperty(JSON_PROPERTY_ENABLE_EXPORT_APPS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getEnableExportApps() {
        return enableExportApps;
    }

    @JsonProperty(JSON_PROPERTY_ENABLE_EXPORT_APPS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEnableExportApps(Boolean enableExportApps) {
        this.enableExportApps = enableExportApps;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OktaPersonalAdminFeatureSettings oktaPersonalAdminFeatureSettings = (OktaPersonalAdminFeatureSettings) o;
        return Objects.equals(this.enableEnduserEntryPoints, oktaPersonalAdminFeatureSettings.enableEnduserEntryPoints)
                && Objects.equals(this.enableExportApps, oktaPersonalAdminFeatureSettings.enableExportApps);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(enableEnduserEntryPoints, enableExportApps);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OktaPersonalAdminFeatureSettings {\n");
        sb.append("    enableEnduserEntryPoints: ").append(toIndentedString(enableEnduserEntryPoints)).append("\n");
        sb.append("    enableExportApps: ").append(toIndentedString(enableExportApps)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
