package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Indicates whether user consent is required or implicit. A consent dialog appears for the end user depending on the
 * values of three elements: *
 * [prompt](/openapi/okta-oauth/oauth/tag/OrgAS/#tag/OrgAS/operation/authorize!in&#x3D;query&amp;path&#x3D;prompt&amp;t&#x3D;request):
 * A query parameter that is used in requests to &#x60;/authorize&#x60; * &#x60;consent_method&#x60; (this property) *
 * [consent](/openapi/okta-management/management/tag/AuthorizationServerScopes/#tag/AuthorizationServerScopes/operation/createOAuth2Scope!path&#x3D;consent&amp;t&#x3D;request):
 * A [Scope](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/AuthorizationServerScopes/)
 * property that allows you to enable or disable user consent for an individual scope | &#x60;prompt&#x60; |
 * &#x60;consent_method&#x60; | &#x60;consent&#x60; | Result | ---------- | ----------- | ---------- | ----------- | |
 * CONSENT | TRUSTED or REQUIRED | REQUIRED | Prompted | | CONSENT | TRUSTED or REQUIRED | FLEXIBLE | Prompted | |
 * CONSENT | TRUSTED | IMPLICIT | Not prompted | | NONE | TRUSTED | FLEXIBLE, IMPLICIT, or REQUIRED | Not prompted | |
 * NONE | REQUIRED | FLEXIBLE or REQUIRED | Prompted | | NONE | REQUIRED | IMPLICIT | Not prompted | &gt; **Notes:**
 * &gt; * If you request a scope that requires consent while using the &#x60;client_credentials&#x60; flow, an error is
 * returned because the flow doesn&#39;t support user consent. &gt; * If the &#x60;prompt&#x60; value is set to
 * &#x60;NONE&#x60;, but the &#x60;consent_method&#x60; and the consent values are set to &#x60;REQUIRED&#x60;, then an
 * error occurs. &gt; * When a scope is requested during a Client Credentials grant flow and &#x60;consent&#x60; is set
 * to &#x60;FLEXIBLE&#x60;, the scope is granted in the access token with no consent prompt. This occurs because there
 * is no user involved in a two-legged OAuth 2.0 [Client
 * Credentials](https://developer.okta.com/docs/guides/implement-grant-type/clientcreds/main/) grant flow.
 */
public enum OpenIdConnectApplicationConsentMethod {

    REQUIRED("REQUIRED"),

    TRUSTED("TRUSTED"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    OpenIdConnectApplicationConsentMethod(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static OpenIdConnectApplicationConsentMethod fromValue(String value) {
        for (OpenIdConnectApplicationConsentMethod b : OpenIdConnectApplicationConsentMethod.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
