package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The type of IdP-initiated sign-in flow that the client supports
 */
@ApiModel(description = "The type of IdP-initiated sign-in flow that the client supports")
@JsonPropertyOrder({ OpenIdConnectApplicationIdpInitiatedLogin.JSON_PROPERTY_DEFAULT_SCOPE,
        OpenIdConnectApplicationIdpInitiatedLogin.JSON_PROPERTY_MODE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class OpenIdConnectApplicationIdpInitiatedLogin implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DEFAULT_SCOPE = "default_scope";
    private List<String> defaultScope = null;

    /**
     * The mode to use for the IdP-initiated sign-in flow. For &#x60;OKTA&#x60; or &#x60;SPEC&#x60; modes, the client
     * must have an &#x60;initiate_login_uri&#x60; registered. &gt; **Note:** For web and SPA apps, if the mode is
     * &#x60;SPEC&#x60; or &#x60;OKTA&#x60;, you must set &#x60;grant_types&#x60; to &#x60;authorization_code&#x60;,
     * &#x60;implicit&#x60;, or &#x60;interaction_code&#x60;.
     */
    public enum ModeEnum {
        DISABLED("DISABLED"),

        SPEC("SPEC"),

        OKTA("OKTA"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        ModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static ModeEnum fromValue(String value) {
            for (ModeEnum b : ModeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_MODE = "mode";
    private ModeEnum mode;

    public OpenIdConnectApplicationIdpInitiatedLogin() {
    }

    public OpenIdConnectApplicationIdpInitiatedLogin defaultScope(List<String> defaultScope) {

        this.defaultScope = defaultScope;
        return this;
    }

    public OpenIdConnectApplicationIdpInitiatedLogin adddefaultScopeItem(String defaultScopeItem) {
        if (this.defaultScope == null) {
            this.defaultScope = new ArrayList<>();
        }
        this.defaultScope.add(defaultScopeItem);
        return this;
    }

    /**
     * The scopes to use for the request when &#x60;mode&#x60; is &#x60;OKTA&#x60;
     *
     * @return defaultScope
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The scopes to use for the request when `mode` is `OKTA`")
    @JsonProperty(JSON_PROPERTY_DEFAULT_SCOPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getDefaultScope() {
        return defaultScope;
    }

    @JsonProperty(JSON_PROPERTY_DEFAULT_SCOPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultScope(List<String> defaultScope) {
        this.defaultScope = defaultScope;
    }

    public OpenIdConnectApplicationIdpInitiatedLogin mode(ModeEnum mode) {

        this.mode = mode;
        return this;
    }

    /**
     * The mode to use for the IdP-initiated sign-in flow. For &#x60;OKTA&#x60; or &#x60;SPEC&#x60; modes, the client
     * must have an &#x60;initiate_login_uri&#x60; registered. &gt; **Note:** For web and SPA apps, if the mode is
     * &#x60;SPEC&#x60; or &#x60;OKTA&#x60;, you must set &#x60;grant_types&#x60; to &#x60;authorization_code&#x60;,
     * &#x60;implicit&#x60;, or &#x60;interaction_code&#x60;.
     *
     * @return mode
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "The mode to use for the IdP-initiated sign-in flow. For `OKTA` or `SPEC` modes, the client must have an `initiate_login_uri` registered. > **Note:** For web and SPA apps, if the mode is `SPEC` or `OKTA`, you must set `grant_types` to `authorization_code`, `implicit`, or `interaction_code`. ")
    @JsonProperty(JSON_PROPERTY_MODE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public ModeEnum getMode() {
        return mode;
    }

    @JsonProperty(JSON_PROPERTY_MODE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setMode(ModeEnum mode) {
        this.mode = mode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OpenIdConnectApplicationIdpInitiatedLogin openIdConnectApplicationIdpInitiatedLogin = (OpenIdConnectApplicationIdpInitiatedLogin) o;
        return Objects.equals(this.defaultScope, openIdConnectApplicationIdpInitiatedLogin.defaultScope)
                && Objects.equals(this.mode, openIdConnectApplicationIdpInitiatedLogin.mode);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(defaultScope, mode);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenIdConnectApplicationIdpInitiatedLogin {\n");
        sb.append("    defaultScope: ").append(toIndentedString(defaultScope)).append("\n");
        sb.append("    mode: ").append(toIndentedString(mode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
