package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OAuthGrantType;
import com.okta.sdk.resource.model.OAuthResponseType;
import com.okta.sdk.resource.model.OpenIdConnectApplicationConsentMethod;
import com.okta.sdk.resource.model.OpenIdConnectApplicationIdpInitiatedLogin;
import com.okta.sdk.resource.model.OpenIdConnectApplicationIssuerMode;
import com.okta.sdk.resource.model.OpenIdConnectApplicationSettingsClientKeys;
import com.okta.sdk.resource.model.OpenIdConnectApplicationSettingsRefreshToken;
import com.okta.sdk.resource.model.OpenIdConnectApplicationType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * OpenIdConnectApplicationSettingsClient
 */
@JsonPropertyOrder({ OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_APPLICATION_TYPE,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_BACKCHANNEL_AUTHENTICATION_REQUEST_SIGNING_ALG,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_BACKCHANNEL_CUSTOM_AUTHENTICATOR_ID,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_BACKCHANNEL_TOKEN_DELIVERY_MODE,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_CLIENT_URI,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_CONSENT_METHOD,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_DPOP_BOUND_ACCESS_TOKENS,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_FRONTCHANNEL_LOGOUT_SESSION_REQUIRED,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_FRONTCHANNEL_LOGOUT_URI,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_GRANT_TYPES,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_IDP_INITIATED_LOGIN,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_INITIATE_LOGIN_URI,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_ISSUER_MODE,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_JWKS,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_JWKS_URI,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_LOGO_URI,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_PARTICIPATE_SLO,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_POLICY_URI,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_POST_LOGOUT_REDIRECT_URIS,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_REDIRECT_URIS,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_REFRESH_TOKEN,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_REQUEST_OBJECT_SIGNING_ALG,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_RESPONSE_TYPES,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_SECTOR_IDENTIFIER_URI,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_SUBJECT_TYPE,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_TOS_URI,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_WILDCARD_REDIRECT })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class OpenIdConnectApplicationSettingsClient implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_APPLICATION_TYPE = "application_type";
    private OpenIdConnectApplicationType applicationType;

    /**
     * The signing algorithm for Client-Initiated Backchannel Authentication (CIBA) signed requests using JWT. If this
     * value isn&#39;t set and a JWT-signed request is sent, the request fails. &gt; **Note:** This property appears for
     * clients with &#x60;urn:openid:params:grant-type:ciba&#x60; defined as one of the &#x60;grant_types&#x60;.
     */
    public enum BackchannelAuthenticationRequestSigningAlgEnum {
        HS256("HS256"),

        HS384("HS384"),

        HS512("HS512"),

        RS256("RS256"),

        RS384("RS384"),

        RS512("RS512"),

        ES256("ES256"),

        ES384("ES384"),

        ES512("ES512"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        BackchannelAuthenticationRequestSigningAlgEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static BackchannelAuthenticationRequestSigningAlgEnum fromValue(String value) {
            for (BackchannelAuthenticationRequestSigningAlgEnum b : BackchannelAuthenticationRequestSigningAlgEnum
                    .values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_BACKCHANNEL_AUTHENTICATION_REQUEST_SIGNING_ALG = "backchannel_authentication_request_signing_alg";
    private BackchannelAuthenticationRequestSigningAlgEnum backchannelAuthenticationRequestSigningAlg;

    public static final String JSON_PROPERTY_BACKCHANNEL_CUSTOM_AUTHENTICATOR_ID = "backchannel_custom_authenticator_id";
    private String backchannelCustomAuthenticatorId;

    /**
     * The delivery mode for Client-Initiated Backchannel Authentication (CIBA). Currently, only &#x60;poll&#x60; is
     * supported. &gt; **Note:** This property appears for clients with &#x60;urn:openid:params:grant-type:ciba&#x60;
     * defined as one of the &#x60;grant_types&#x60;.
     */
    public enum BackchannelTokenDeliveryModeEnum {
        POLL("poll"),

        PING("ping"),

        PUSH("push"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        BackchannelTokenDeliveryModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static BackchannelTokenDeliveryModeEnum fromValue(String value) {
            for (BackchannelTokenDeliveryModeEnum b : BackchannelTokenDeliveryModeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_BACKCHANNEL_TOKEN_DELIVERY_MODE = "backchannel_token_delivery_mode";
    private BackchannelTokenDeliveryModeEnum backchannelTokenDeliveryMode;

    public static final String JSON_PROPERTY_CLIENT_URI = "client_uri";
    private String clientUri;

    public static final String JSON_PROPERTY_CONSENT_METHOD = "consent_method";
    private OpenIdConnectApplicationConsentMethod consentMethod = OpenIdConnectApplicationConsentMethod.TRUSTED;

    public static final String JSON_PROPERTY_DPOP_BOUND_ACCESS_TOKENS = "dpop_bound_access_tokens";
    private Boolean dpopBoundAccessTokens = false;

    public static final String JSON_PROPERTY_FRONTCHANNEL_LOGOUT_SESSION_REQUIRED = "frontchannel_logout_session_required";
    private Boolean frontchannelLogoutSessionRequired;

    public static final String JSON_PROPERTY_FRONTCHANNEL_LOGOUT_URI = "frontchannel_logout_uri";
    private String frontchannelLogoutUri;

    public static final String JSON_PROPERTY_GRANT_TYPES = "grant_types";
    private List<OAuthGrantType> grantTypes = new ArrayList<>();

    public static final String JSON_PROPERTY_IDP_INITIATED_LOGIN = "idp_initiated_login";
    private OpenIdConnectApplicationIdpInitiatedLogin idpInitiatedLogin;

    public static final String JSON_PROPERTY_INITIATE_LOGIN_URI = "initiate_login_uri";
    private String initiateLoginUri;

    public static final String JSON_PROPERTY_ISSUER_MODE = "issuer_mode";
    private OpenIdConnectApplicationIssuerMode issuerMode;

    public static final String JSON_PROPERTY_JWKS = "jwks";
    private OpenIdConnectApplicationSettingsClientKeys jwks;

    public static final String JSON_PROPERTY_JWKS_URI = "jwks_uri";
    private String jwksUri;

    public static final String JSON_PROPERTY_LOGO_URI = "logo_uri";
    private String logoUri;

    public static final String JSON_PROPERTY_PARTICIPATE_SLO = "participate_slo";
    private Boolean participateSlo;

    public static final String JSON_PROPERTY_POLICY_URI = "policy_uri";
    private String policyUri;

    public static final String JSON_PROPERTY_POST_LOGOUT_REDIRECT_URIS = "post_logout_redirect_uris";
    private List<String> postLogoutRedirectUris = null;

    public static final String JSON_PROPERTY_REDIRECT_URIS = "redirect_uris";
    private List<String> redirectUris = null;

    public static final String JSON_PROPERTY_REFRESH_TOKEN = "refresh_token";
    private OpenIdConnectApplicationSettingsRefreshToken refreshToken;

    /**
     * The type of JSON Web Key Set (JWKS) algorithm that must be used for signing request objects
     */
    public enum RequestObjectSigningAlgEnum {
        HS256("HS256"),

        HS384("HS384"),

        HS512("HS512"),

        RS256("RS256"),

        RS384("RS384"),

        RS512("RS512"),

        ES256("ES256"),

        ES384("ES384"),

        ES512("ES512"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        RequestObjectSigningAlgEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static RequestObjectSigningAlgEnum fromValue(String value) {
            for (RequestObjectSigningAlgEnum b : RequestObjectSigningAlgEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_REQUEST_OBJECT_SIGNING_ALG = "request_object_signing_alg";
    private RequestObjectSigningAlgEnum requestObjectSigningAlg;

    public static final String JSON_PROPERTY_RESPONSE_TYPES = "response_types";
    private List<OAuthResponseType> responseTypes = null;

    public static final String JSON_PROPERTY_SECTOR_IDENTIFIER_URI = "sector_identifier_uri";
    private String sectorIdentifierUri;

    /**
     * Type of the subject
     */
    public enum SubjectTypeEnum {
        PUBLIC("public"),

        PAIRWISE("pairwise"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        SubjectTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static SubjectTypeEnum fromValue(String value) {
            for (SubjectTypeEnum b : SubjectTypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_SUBJECT_TYPE = "subject_type";
    private SubjectTypeEnum subjectType;

    public static final String JSON_PROPERTY_TOS_URI = "tos_uri";
    private String tosUri;

    /**
     * Indicates if the client is allowed to use wildcard matching of &#x60;redirect_uris&#x60;
     */
    public enum WildcardRedirectEnum {
        DISABLED("DISABLED"),

        SUBDOMAIN("SUBDOMAIN"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        WildcardRedirectEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static WildcardRedirectEnum fromValue(String value) {
            for (WildcardRedirectEnum b : WildcardRedirectEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_WILDCARD_REDIRECT = "wildcard_redirect";
    private WildcardRedirectEnum wildcardRedirect;

    public OpenIdConnectApplicationSettingsClient() {
    }

    public OpenIdConnectApplicationSettingsClient applicationType(OpenIdConnectApplicationType applicationType) {

        this.applicationType = applicationType;
        return this;
    }

    /**
     * Get applicationType
     *
     * @return applicationType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_APPLICATION_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OpenIdConnectApplicationType getApplicationType() {
        return applicationType;
    }

    @JsonProperty(JSON_PROPERTY_APPLICATION_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setApplicationType(OpenIdConnectApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    public OpenIdConnectApplicationSettingsClient backchannelAuthenticationRequestSigningAlg(
            BackchannelAuthenticationRequestSigningAlgEnum backchannelAuthenticationRequestSigningAlg) {

        this.backchannelAuthenticationRequestSigningAlg = backchannelAuthenticationRequestSigningAlg;
        return this;
    }

    /**
     * The signing algorithm for Client-Initiated Backchannel Authentication (CIBA) signed requests using JWT. If this
     * value isn&#39;t set and a JWT-signed request is sent, the request fails. &gt; **Note:** This property appears for
     * clients with &#x60;urn:openid:params:grant-type:ciba&#x60; defined as one of the &#x60;grant_types&#x60;.
     *
     * @return backchannelAuthenticationRequestSigningAlg
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The signing algorithm for Client-Initiated Backchannel Authentication (CIBA) signed requests using JWT. If this value isn't set and a JWT-signed request is sent, the request fails. > **Note:** This property appears for clients with `urn:openid:params:grant-type:ciba` defined as one of the `grant_types`. ")
    @JsonProperty(JSON_PROPERTY_BACKCHANNEL_AUTHENTICATION_REQUEST_SIGNING_ALG)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public BackchannelAuthenticationRequestSigningAlgEnum getBackchannelAuthenticationRequestSigningAlg() {
        return backchannelAuthenticationRequestSigningAlg;
    }

    @JsonProperty(JSON_PROPERTY_BACKCHANNEL_AUTHENTICATION_REQUEST_SIGNING_ALG)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setBackchannelAuthenticationRequestSigningAlg(
            BackchannelAuthenticationRequestSigningAlgEnum backchannelAuthenticationRequestSigningAlg) {
        this.backchannelAuthenticationRequestSigningAlg = backchannelAuthenticationRequestSigningAlg;
    }

    public OpenIdConnectApplicationSettingsClient backchannelCustomAuthenticatorId(
            String backchannelCustomAuthenticatorId) {

        this.backchannelCustomAuthenticatorId = backchannelCustomAuthenticatorId;
        return this;
    }

    /**
     * The ID of the custom authenticator that authenticates the user &gt; **Note:** This property appears for clients
     * with &#x60;urn:openid:params:grant-type:ciba&#x60; defined as one of the &#x60;grant_types&#x60;.
     *
     * @return backchannelCustomAuthenticatorId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The ID of the custom authenticator that authenticates the user > **Note:** This property appears for clients with `urn:openid:params:grant-type:ciba` defined as one of the `grant_types`. ")
    @JsonProperty(JSON_PROPERTY_BACKCHANNEL_CUSTOM_AUTHENTICATOR_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getBackchannelCustomAuthenticatorId() {
        return backchannelCustomAuthenticatorId;
    }

    @JsonProperty(JSON_PROPERTY_BACKCHANNEL_CUSTOM_AUTHENTICATOR_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setBackchannelCustomAuthenticatorId(String backchannelCustomAuthenticatorId) {
        this.backchannelCustomAuthenticatorId = backchannelCustomAuthenticatorId;
    }

    public OpenIdConnectApplicationSettingsClient backchannelTokenDeliveryMode(
            BackchannelTokenDeliveryModeEnum backchannelTokenDeliveryMode) {

        this.backchannelTokenDeliveryMode = backchannelTokenDeliveryMode;
        return this;
    }

    /**
     * The delivery mode for Client-Initiated Backchannel Authentication (CIBA). Currently, only &#x60;poll&#x60; is
     * supported. &gt; **Note:** This property appears for clients with &#x60;urn:openid:params:grant-type:ciba&#x60;
     * defined as one of the &#x60;grant_types&#x60;.
     *
     * @return backchannelTokenDeliveryMode
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The delivery mode for Client-Initiated Backchannel Authentication (CIBA).  Currently, only `poll` is supported. > **Note:** This property appears for clients with `urn:openid:params:grant-type:ciba` defined as one of the `grant_types`. ")
    @JsonProperty(JSON_PROPERTY_BACKCHANNEL_TOKEN_DELIVERY_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public BackchannelTokenDeliveryModeEnum getBackchannelTokenDeliveryMode() {
        return backchannelTokenDeliveryMode;
    }

    @JsonProperty(JSON_PROPERTY_BACKCHANNEL_TOKEN_DELIVERY_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setBackchannelTokenDeliveryMode(BackchannelTokenDeliveryModeEnum backchannelTokenDeliveryMode) {
        this.backchannelTokenDeliveryMode = backchannelTokenDeliveryMode;
    }

    public OpenIdConnectApplicationSettingsClient clientUri(String clientUri) {

        this.clientUri = clientUri;
        return this;
    }

    /**
     * URL string of a web page providing information about the client
     *
     * @return clientUri
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "URL string of a web page providing information about the client")
    @JsonProperty(JSON_PROPERTY_CLIENT_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getClientUri() {
        return clientUri;
    }

    @JsonProperty(JSON_PROPERTY_CLIENT_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClientUri(String clientUri) {
        this.clientUri = clientUri;
    }

    public OpenIdConnectApplicationSettingsClient consentMethod(OpenIdConnectApplicationConsentMethod consentMethod) {

        this.consentMethod = consentMethod;
        return this;
    }

    /**
     * Get consentMethod
     *
     * @return consentMethod
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CONSENT_METHOD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OpenIdConnectApplicationConsentMethod getConsentMethod() {
        return consentMethod;
    }

    @JsonProperty(JSON_PROPERTY_CONSENT_METHOD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setConsentMethod(OpenIdConnectApplicationConsentMethod consentMethod) {
        this.consentMethod = consentMethod;
    }

    public OpenIdConnectApplicationSettingsClient dpopBoundAccessTokens(Boolean dpopBoundAccessTokens) {

        this.dpopBoundAccessTokens = dpopBoundAccessTokens;
        return this;
    }

    /**
     * Indicates that the client application uses Demonstrating Proof-of-Possession (DPoP) for token requests. If
     * &#x60;true&#x60;, the authorization server rejects token requests from this client that don&#39;t contain the
     * DPoP header. &gt; **Note:** If &#x60;dpop_bound_access_tokens&#x60; is true, then &#x60;client_credentials&#x60;
     * and &#x60;implicit&#x60; aren&#39;t allowed in &#x60;grant_types&#x60;.
     *
     * @return dpopBoundAccessTokens
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates that the client application uses Demonstrating Proof-of-Possession (DPoP) for token requests. If `true`, the authorization server rejects token requests from this client that don't contain the DPoP header. > **Note:** If `dpop_bound_access_tokens` is true, then `client_credentials` and `implicit` aren't allowed in `grant_types`. ")
    @JsonProperty(JSON_PROPERTY_DPOP_BOUND_ACCESS_TOKENS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getDpopBoundAccessTokens() {
        return dpopBoundAccessTokens;
    }

    @JsonProperty(JSON_PROPERTY_DPOP_BOUND_ACCESS_TOKENS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDpopBoundAccessTokens(Boolean dpopBoundAccessTokens) {
        this.dpopBoundAccessTokens = dpopBoundAccessTokens;
    }

    public OpenIdConnectApplicationSettingsClient frontchannelLogoutSessionRequired(
            Boolean frontchannelLogoutSessionRequired) {

        this.frontchannelLogoutSessionRequired = frontchannelLogoutSessionRequired;
        return this;
    }

    /**
     * &lt;div class&#x3D;\&quot;x-lifecycle-container\&quot;&gt;&lt;x-lifecycle
     * class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt; &lt;x-lifecycle
     * class&#x3D;\&quot;oie\&quot;&gt;&lt;/x-lifecycle&gt;&lt;/div&gt;Determines whether Okta sends &#x60;sid&#x60; and
     * &#x60;iss&#x60; in the logout request
     *
     * @return frontchannelLogoutSessionRequired
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "<div class=\"x-lifecycle-container\"><x-lifecycle class=\"ea\"></x-lifecycle> <x-lifecycle class=\"oie\"></x-lifecycle></div>Determines whether Okta sends `sid` and `iss` in the logout request")
    @JsonProperty(JSON_PROPERTY_FRONTCHANNEL_LOGOUT_SESSION_REQUIRED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getFrontchannelLogoutSessionRequired() {
        return frontchannelLogoutSessionRequired;
    }

    @JsonProperty(JSON_PROPERTY_FRONTCHANNEL_LOGOUT_SESSION_REQUIRED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFrontchannelLogoutSessionRequired(Boolean frontchannelLogoutSessionRequired) {
        this.frontchannelLogoutSessionRequired = frontchannelLogoutSessionRequired;
    }

    public OpenIdConnectApplicationSettingsClient frontchannelLogoutUri(String frontchannelLogoutUri) {

        this.frontchannelLogoutUri = frontchannelLogoutUri;
        return this;
    }

    /**
     * &lt;div class&#x3D;\&quot;x-lifecycle-container\&quot;&gt;&lt;x-lifecycle
     * class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt; &lt;x-lifecycle
     * class&#x3D;\&quot;oie\&quot;&gt;&lt;/x-lifecycle&gt;&lt;/div&gt;URL where Okta sends the logout request
     *
     * @return frontchannelLogoutUri
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "<div class=\"x-lifecycle-container\"><x-lifecycle class=\"ea\"></x-lifecycle> <x-lifecycle class=\"oie\"></x-lifecycle></div>URL where Okta sends the logout request")
    @JsonProperty(JSON_PROPERTY_FRONTCHANNEL_LOGOUT_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getFrontchannelLogoutUri() {
        return frontchannelLogoutUri;
    }

    @JsonProperty(JSON_PROPERTY_FRONTCHANNEL_LOGOUT_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFrontchannelLogoutUri(String frontchannelLogoutUri) {
        this.frontchannelLogoutUri = frontchannelLogoutUri;
    }

    public OpenIdConnectApplicationSettingsClient grantTypes(List<OAuthGrantType> grantTypes) {

        this.grantTypes = grantTypes;
        return this;
    }

    public OpenIdConnectApplicationSettingsClient addgrantTypesItem(OAuthGrantType grantTypesItem) {
        if (this.grantTypes == null) {
            this.grantTypes = new ArrayList<>();
        }
        this.grantTypes.add(grantTypesItem);
        return this;
    }

    /**
     * Get grantTypes
     *
     * @return grantTypes
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_GRANT_TYPES)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public List<OAuthGrantType> getGrantTypes() {
        return grantTypes;
    }

    @JsonProperty(JSON_PROPERTY_GRANT_TYPES)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setGrantTypes(List<OAuthGrantType> grantTypes) {
        this.grantTypes = grantTypes;
    }

    public OpenIdConnectApplicationSettingsClient idpInitiatedLogin(
            OpenIdConnectApplicationIdpInitiatedLogin idpInitiatedLogin) {

        this.idpInitiatedLogin = idpInitiatedLogin;
        return this;
    }

    /**
     * Get idpInitiatedLogin
     *
     * @return idpInitiatedLogin
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_IDP_INITIATED_LOGIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OpenIdConnectApplicationIdpInitiatedLogin getIdpInitiatedLogin() {
        return idpInitiatedLogin;
    }

    @JsonProperty(JSON_PROPERTY_IDP_INITIATED_LOGIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIdpInitiatedLogin(OpenIdConnectApplicationIdpInitiatedLogin idpInitiatedLogin) {
        this.idpInitiatedLogin = idpInitiatedLogin;
    }

    public OpenIdConnectApplicationSettingsClient initiateLoginUri(String initiateLoginUri) {

        this.initiateLoginUri = initiateLoginUri;
        return this;
    }

    /**
     * URL string that a third party can use to initiate the sign-in flow by the client
     *
     * @return initiateLoginUri
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "URL string that a third party can use to initiate the sign-in flow by the client")
    @JsonProperty(JSON_PROPERTY_INITIATE_LOGIN_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getInitiateLoginUri() {
        return initiateLoginUri;
    }

    @JsonProperty(JSON_PROPERTY_INITIATE_LOGIN_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setInitiateLoginUri(String initiateLoginUri) {
        this.initiateLoginUri = initiateLoginUri;
    }

    public OpenIdConnectApplicationSettingsClient issuerMode(OpenIdConnectApplicationIssuerMode issuerMode) {

        this.issuerMode = issuerMode;
        return this;
    }

    /**
     * Get issuerMode
     *
     * @return issuerMode
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ISSUER_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OpenIdConnectApplicationIssuerMode getIssuerMode() {
        return issuerMode;
    }

    @JsonProperty(JSON_PROPERTY_ISSUER_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIssuerMode(OpenIdConnectApplicationIssuerMode issuerMode) {
        this.issuerMode = issuerMode;
    }

    public OpenIdConnectApplicationSettingsClient jwks(OpenIdConnectApplicationSettingsClientKeys jwks) {

        this.jwks = jwks;
        return this;
    }

    /**
     * Get jwks
     *
     * @return jwks
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_JWKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OpenIdConnectApplicationSettingsClientKeys getJwks() {
        return jwks;
    }

    @JsonProperty(JSON_PROPERTY_JWKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setJwks(OpenIdConnectApplicationSettingsClientKeys jwks) {
        this.jwks = jwks;
    }

    public OpenIdConnectApplicationSettingsClient jwksUri(String jwksUri) {

        this.jwksUri = jwksUri;
        return this;
    }

    /**
     * URL string that references a JSON Web Key Set for validating JWTs presented to Okta
     *
     * @return jwksUri
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "URL string that references a JSON Web Key Set for validating JWTs presented to Okta")
    @JsonProperty(JSON_PROPERTY_JWKS_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getJwksUri() {
        return jwksUri;
    }

    @JsonProperty(JSON_PROPERTY_JWKS_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public OpenIdConnectApplicationSettingsClient logoUri(String logoUri) {

        this.logoUri = logoUri;
        return this;
    }

    /**
     * The URL string that references a logo for the client. This logo appears on the client tile in the End-User
     * Dashboard. It also appears on the client consent dialog during the client consent flow.
     *
     * @return logoUri
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The URL string that references a logo for the client. This logo appears on the client tile in the End-User Dashboard. It also appears on the client consent dialog during the client consent flow.")
    @JsonProperty(JSON_PROPERTY_LOGO_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLogoUri() {
        return logoUri;
    }

    @JsonProperty(JSON_PROPERTY_LOGO_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLogoUri(String logoUri) {
        this.logoUri = logoUri;
    }

    public OpenIdConnectApplicationSettingsClient participateSlo(Boolean participateSlo) {

        this.participateSlo = participateSlo;
        return this;
    }

    /**
     * &lt;div class&#x3D;\&quot;x-lifecycle-container\&quot;&gt;&lt;x-lifecycle
     * class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt; &lt;x-lifecycle
     * class&#x3D;\&quot;oie\&quot;&gt;&lt;/x-lifecycle&gt;&lt;/div&gt;Allows the app to participate in front-channel
     * Single Logout &gt; **Note:** You can only enable &#x60;participate_slo&#x60; for &#x60;web&#x60; and
     * &#x60;browser&#x60; application types (&#x60;application_type&#x60;).
     *
     * @return participateSlo
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "<div class=\"x-lifecycle-container\"><x-lifecycle class=\"ea\"></x-lifecycle> <x-lifecycle class=\"oie\"></x-lifecycle></div>Allows the app to participate in front-channel Single Logout  > **Note:** You can only enable `participate_slo` for `web` and `browser` application types (`application_type`). ")
    @JsonProperty(JSON_PROPERTY_PARTICIPATE_SLO)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getParticipateSlo() {
        return participateSlo;
    }

    @JsonProperty(JSON_PROPERTY_PARTICIPATE_SLO)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setParticipateSlo(Boolean participateSlo) {
        this.participateSlo = participateSlo;
    }

    public OpenIdConnectApplicationSettingsClient policyUri(String policyUri) {

        this.policyUri = policyUri;
        return this;
    }

    /**
     * URL string of a web page providing the client&#39;s policy document
     *
     * @return policyUri
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "URL string of a web page providing the client's policy document")
    @JsonProperty(JSON_PROPERTY_POLICY_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPolicyUri() {
        return policyUri;
    }

    @JsonProperty(JSON_PROPERTY_POLICY_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPolicyUri(String policyUri) {
        this.policyUri = policyUri;
    }

    public OpenIdConnectApplicationSettingsClient postLogoutRedirectUris(List<String> postLogoutRedirectUris) {

        this.postLogoutRedirectUris = postLogoutRedirectUris;
        return this;
    }

    public OpenIdConnectApplicationSettingsClient addpostLogoutRedirectUrisItem(String postLogoutRedirectUrisItem) {
        if (this.postLogoutRedirectUris == null) {
            this.postLogoutRedirectUris = new ArrayList<>();
        }
        this.postLogoutRedirectUris.add(postLogoutRedirectUrisItem);
        return this;
    }

    /**
     * Array of redirection URI strings for relying party-initiated logouts
     *
     * @return postLogoutRedirectUris
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Array of redirection URI strings for relying party-initiated logouts")
    @JsonProperty(JSON_PROPERTY_POST_LOGOUT_REDIRECT_URIS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getPostLogoutRedirectUris() {
        return postLogoutRedirectUris;
    }

    @JsonProperty(JSON_PROPERTY_POST_LOGOUT_REDIRECT_URIS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPostLogoutRedirectUris(List<String> postLogoutRedirectUris) {
        this.postLogoutRedirectUris = postLogoutRedirectUris;
    }

    public OpenIdConnectApplicationSettingsClient redirectUris(List<String> redirectUris) {

        this.redirectUris = redirectUris;
        return this;
    }

    public OpenIdConnectApplicationSettingsClient addredirectUrisItem(String redirectUrisItem) {
        if (this.redirectUris == null) {
            this.redirectUris = new ArrayList<>();
        }
        this.redirectUris.add(redirectUrisItem);
        return this;
    }

    /**
     * Array of redirection URI strings for use in redirect-based flows. &gt; **Note:** At least one
     * &#x60;redirect_uris&#x60; and &#x60;response_types&#x60; are required for all client types, with exceptions: if
     * the client uses the [Resource Owner Password ](https://tools.ietf.org/html/rfc6749#section-4.3)flow
     * (&#x60;grant_types&#x60; contains &#x60;password&#x60;) or [Client
     * Credentials](https://tools.ietf.org/html/rfc6749#section-4.4)flow (&#x60;grant_types&#x60; contains
     * &#x60;client_credentials&#x60;), then no &#x60;redirect_uris&#x60; or &#x60;response_types&#x60; is necessary. In
     * these cases, you can pass either null or an empty array for these attributes.
     *
     * @return redirectUris
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Array of redirection URI strings for use in redirect-based flows. > **Note:** At least one `redirect_uris` and `response_types` are required for all client types, with exceptions: if the client uses the [Resource Owner Password ](https://tools.ietf.org/html/rfc6749#section-4.3)flow (`grant_types` contains `password`) or [Client Credentials](https://tools.ietf.org/html/rfc6749#section-4.4)flow (`grant_types` contains `client_credentials`), then no `redirect_uris` or `response_types` is necessary. In these cases, you can pass either null or an empty array for these attributes.")
    @JsonProperty(JSON_PROPERTY_REDIRECT_URIS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getRedirectUris() {
        return redirectUris;
    }

    @JsonProperty(JSON_PROPERTY_REDIRECT_URIS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public OpenIdConnectApplicationSettingsClient refreshToken(
            OpenIdConnectApplicationSettingsRefreshToken refreshToken) {

        this.refreshToken = refreshToken;
        return this;
    }

    /**
     * Get refreshToken
     *
     * @return refreshToken
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_REFRESH_TOKEN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OpenIdConnectApplicationSettingsRefreshToken getRefreshToken() {
        return refreshToken;
    }

    @JsonProperty(JSON_PROPERTY_REFRESH_TOKEN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRefreshToken(OpenIdConnectApplicationSettingsRefreshToken refreshToken) {
        this.refreshToken = refreshToken;
    }

    public OpenIdConnectApplicationSettingsClient requestObjectSigningAlg(
            RequestObjectSigningAlgEnum requestObjectSigningAlg) {

        this.requestObjectSigningAlg = requestObjectSigningAlg;
        return this;
    }

    /**
     * The type of JSON Web Key Set (JWKS) algorithm that must be used for signing request objects
     *
     * @return requestObjectSigningAlg
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The type of JSON Web Key Set (JWKS) algorithm that must be used for signing request objects")
    @JsonProperty(JSON_PROPERTY_REQUEST_OBJECT_SIGNING_ALG)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public RequestObjectSigningAlgEnum getRequestObjectSigningAlg() {
        return requestObjectSigningAlg;
    }

    @JsonProperty(JSON_PROPERTY_REQUEST_OBJECT_SIGNING_ALG)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRequestObjectSigningAlg(RequestObjectSigningAlgEnum requestObjectSigningAlg) {
        this.requestObjectSigningAlg = requestObjectSigningAlg;
    }

    public OpenIdConnectApplicationSettingsClient responseTypes(List<OAuthResponseType> responseTypes) {

        this.responseTypes = responseTypes;
        return this;
    }

    public OpenIdConnectApplicationSettingsClient addresponseTypesItem(OAuthResponseType responseTypesItem) {
        if (this.responseTypes == null) {
            this.responseTypes = new ArrayList<>();
        }
        this.responseTypes.add(responseTypesItem);
        return this;
    }

    /**
     * Array of OAuth 2.0 response type strings
     *
     * @return responseTypes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Array of OAuth 2.0 response type strings")
    @JsonProperty(JSON_PROPERTY_RESPONSE_TYPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<OAuthResponseType> getResponseTypes() {
        return responseTypes;
    }

    @JsonProperty(JSON_PROPERTY_RESPONSE_TYPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setResponseTypes(List<OAuthResponseType> responseTypes) {
        this.responseTypes = responseTypes;
    }

    public OpenIdConnectApplicationSettingsClient sectorIdentifierUri(String sectorIdentifierUri) {

        this.sectorIdentifierUri = sectorIdentifierUri;
        return this;
    }

    /**
     * The sector identifier used for pairwise &#x60;subject_type&#x60;. See [OIDC Pairwise Identifier
     * Algorithm](https://openid.net/specs/openid-connect-messages-1_0-20.html#idtype.pairwise.alg)
     *
     * @return sectorIdentifierUri
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The sector identifier used for pairwise `subject_type`. See [OIDC Pairwise Identifier Algorithm](https://openid.net/specs/openid-connect-messages-1_0-20.html#idtype.pairwise.alg)")
    @JsonProperty(JSON_PROPERTY_SECTOR_IDENTIFIER_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getSectorIdentifierUri() {
        return sectorIdentifierUri;
    }

    @JsonProperty(JSON_PROPERTY_SECTOR_IDENTIFIER_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSectorIdentifierUri(String sectorIdentifierUri) {
        this.sectorIdentifierUri = sectorIdentifierUri;
    }

    public OpenIdConnectApplicationSettingsClient subjectType(SubjectTypeEnum subjectType) {

        this.subjectType = subjectType;
        return this;
    }

    /**
     * Type of the subject
     *
     * @return subjectType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Type of the subject")
    @JsonProperty(JSON_PROPERTY_SUBJECT_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SubjectTypeEnum getSubjectType() {
        return subjectType;
    }

    @JsonProperty(JSON_PROPERTY_SUBJECT_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSubjectType(SubjectTypeEnum subjectType) {
        this.subjectType = subjectType;
    }

    public OpenIdConnectApplicationSettingsClient tosUri(String tosUri) {

        this.tosUri = tosUri;
        return this;
    }

    /**
     * URL string of a web page providing the client&#39;s terms of service document
     *
     * @return tosUri
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "URL string of a web page providing the client's terms of service document")
    @JsonProperty(JSON_PROPERTY_TOS_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getTosUri() {
        return tosUri;
    }

    @JsonProperty(JSON_PROPERTY_TOS_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTosUri(String tosUri) {
        this.tosUri = tosUri;
    }

    public OpenIdConnectApplicationSettingsClient wildcardRedirect(WildcardRedirectEnum wildcardRedirect) {

        this.wildcardRedirect = wildcardRedirect;
        return this;
    }

    /**
     * Indicates if the client is allowed to use wildcard matching of &#x60;redirect_uris&#x60;
     *
     * @return wildcardRedirect
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates if the client is allowed to use wildcard matching of `redirect_uris`")
    @JsonProperty(JSON_PROPERTY_WILDCARD_REDIRECT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public WildcardRedirectEnum getWildcardRedirect() {
        return wildcardRedirect;
    }

    @JsonProperty(JSON_PROPERTY_WILDCARD_REDIRECT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setWildcardRedirect(WildcardRedirectEnum wildcardRedirect) {
        this.wildcardRedirect = wildcardRedirect;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OpenIdConnectApplicationSettingsClient openIdConnectApplicationSettingsClient = (OpenIdConnectApplicationSettingsClient) o;
        return Objects.equals(this.applicationType, openIdConnectApplicationSettingsClient.applicationType)
                && Objects.equals(this.backchannelAuthenticationRequestSigningAlg,
                        openIdConnectApplicationSettingsClient.backchannelAuthenticationRequestSigningAlg)
                && Objects.equals(this.backchannelCustomAuthenticatorId,
                        openIdConnectApplicationSettingsClient.backchannelCustomAuthenticatorId)
                && Objects.equals(this.backchannelTokenDeliveryMode,
                        openIdConnectApplicationSettingsClient.backchannelTokenDeliveryMode)
                && Objects.equals(this.clientUri, openIdConnectApplicationSettingsClient.clientUri)
                && Objects.equals(this.consentMethod, openIdConnectApplicationSettingsClient.consentMethod)
                && Objects.equals(this.dpopBoundAccessTokens,
                        openIdConnectApplicationSettingsClient.dpopBoundAccessTokens)
                && Objects.equals(this.frontchannelLogoutSessionRequired,
                        openIdConnectApplicationSettingsClient.frontchannelLogoutSessionRequired)
                && Objects.equals(this.frontchannelLogoutUri,
                        openIdConnectApplicationSettingsClient.frontchannelLogoutUri)
                && Objects.equals(this.grantTypes, openIdConnectApplicationSettingsClient.grantTypes)
                && Objects.equals(this.idpInitiatedLogin, openIdConnectApplicationSettingsClient.idpInitiatedLogin)
                && Objects.equals(this.initiateLoginUri, openIdConnectApplicationSettingsClient.initiateLoginUri)
                && Objects.equals(this.issuerMode, openIdConnectApplicationSettingsClient.issuerMode)
                && Objects.equals(this.jwks, openIdConnectApplicationSettingsClient.jwks)
                && Objects.equals(this.jwksUri, openIdConnectApplicationSettingsClient.jwksUri)
                && Objects.equals(this.logoUri, openIdConnectApplicationSettingsClient.logoUri)
                && Objects.equals(this.participateSlo, openIdConnectApplicationSettingsClient.participateSlo)
                && Objects.equals(this.policyUri, openIdConnectApplicationSettingsClient.policyUri)
                && Objects.equals(this.postLogoutRedirectUris,
                        openIdConnectApplicationSettingsClient.postLogoutRedirectUris)
                && Objects.equals(this.redirectUris, openIdConnectApplicationSettingsClient.redirectUris)
                && Objects.equals(this.refreshToken, openIdConnectApplicationSettingsClient.refreshToken)
                && Objects.equals(this.requestObjectSigningAlg,
                        openIdConnectApplicationSettingsClient.requestObjectSigningAlg)
                && Objects.equals(this.responseTypes, openIdConnectApplicationSettingsClient.responseTypes)
                && Objects.equals(this.sectorIdentifierUri, openIdConnectApplicationSettingsClient.sectorIdentifierUri)
                && Objects.equals(this.subjectType, openIdConnectApplicationSettingsClient.subjectType)
                && Objects.equals(this.tosUri, openIdConnectApplicationSettingsClient.tosUri)
                && Objects.equals(this.wildcardRedirect, openIdConnectApplicationSettingsClient.wildcardRedirect);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(applicationType, backchannelAuthenticationRequestSigningAlg,
                backchannelCustomAuthenticatorId, backchannelTokenDeliveryMode, clientUri, consentMethod,
                dpopBoundAccessTokens, frontchannelLogoutSessionRequired, frontchannelLogoutUri, grantTypes,
                idpInitiatedLogin, initiateLoginUri, issuerMode, jwks, jwksUri, logoUri, participateSlo, policyUri,
                postLogoutRedirectUris, redirectUris, refreshToken, requestObjectSigningAlg, responseTypes,
                sectorIdentifierUri, subjectType, tosUri, wildcardRedirect);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenIdConnectApplicationSettingsClient {\n");
        sb.append("    applicationType: ").append(toIndentedString(applicationType)).append("\n");
        sb.append("    backchannelAuthenticationRequestSigningAlg: ")
                .append(toIndentedString(backchannelAuthenticationRequestSigningAlg)).append("\n");
        sb.append("    backchannelCustomAuthenticatorId: ").append(toIndentedString(backchannelCustomAuthenticatorId))
                .append("\n");
        sb.append("    backchannelTokenDeliveryMode: ").append(toIndentedString(backchannelTokenDeliveryMode))
                .append("\n");
        sb.append("    clientUri: ").append(toIndentedString(clientUri)).append("\n");
        sb.append("    consentMethod: ").append(toIndentedString(consentMethod)).append("\n");
        sb.append("    dpopBoundAccessTokens: ").append(toIndentedString(dpopBoundAccessTokens)).append("\n");
        sb.append("    frontchannelLogoutSessionRequired: ").append(toIndentedString(frontchannelLogoutSessionRequired))
                .append("\n");
        sb.append("    frontchannelLogoutUri: ").append(toIndentedString(frontchannelLogoutUri)).append("\n");
        sb.append("    grantTypes: ").append(toIndentedString(grantTypes)).append("\n");
        sb.append("    idpInitiatedLogin: ").append(toIndentedString(idpInitiatedLogin)).append("\n");
        sb.append("    initiateLoginUri: ").append(toIndentedString(initiateLoginUri)).append("\n");
        sb.append("    issuerMode: ").append(toIndentedString(issuerMode)).append("\n");
        sb.append("    jwks: ").append(toIndentedString(jwks)).append("\n");
        sb.append("    jwksUri: ").append(toIndentedString(jwksUri)).append("\n");
        sb.append("    logoUri: ").append(toIndentedString(logoUri)).append("\n");
        sb.append("    participateSlo: ").append(toIndentedString(participateSlo)).append("\n");
        sb.append("    policyUri: ").append(toIndentedString(policyUri)).append("\n");
        sb.append("    postLogoutRedirectUris: ").append(toIndentedString(postLogoutRedirectUris)).append("\n");
        sb.append("    redirectUris: ").append(toIndentedString(redirectUris)).append("\n");
        sb.append("    refreshToken: ").append(toIndentedString(refreshToken)).append("\n");
        sb.append("    requestObjectSigningAlg: ").append(toIndentedString(requestObjectSigningAlg)).append("\n");
        sb.append("    responseTypes: ").append(toIndentedString(responseTypes)).append("\n");
        sb.append("    sectorIdentifierUri: ").append(toIndentedString(sectorIdentifierUri)).append("\n");
        sb.append("    subjectType: ").append(toIndentedString(subjectType)).append("\n");
        sb.append("    tosUri: ").append(toIndentedString(tosUri)).append("\n");
        sb.append("    wildcardRedirect: ").append(toIndentedString(wildcardRedirect)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
