package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OptInStatusResponseLinks;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * OptInStatusResponse
 */
@JsonPropertyOrder({ OptInStatusResponse.JSON_PROPERTY_OPT_IN_STATUS, OptInStatusResponse.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class OptInStatusResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Gets or Sets optInStatus
     */
    public enum OptInStatusEnum {
        OPTING_IN("OPTING_IN"),

        OPTED_IN("OPTED_IN"),

        OPTING_OUT("OPTING_OUT"),

        OPTED_OUT("OPTED_OUT"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        OptInStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static OptInStatusEnum fromValue(String value) {
            for (OptInStatusEnum b : OptInStatusEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_OPT_IN_STATUS = "optInStatus";
    private OptInStatusEnum optInStatus;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private OptInStatusResponseLinks links;

    public OptInStatusResponse() {
    }

    public OptInStatusResponse optInStatus(OptInStatusEnum optInStatus) {

        this.optInStatus = optInStatus;
        return this;
    }

    /**
     * Get optInStatus
     *
     * @return optInStatus
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_OPT_IN_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OptInStatusEnum getOptInStatus() {
        return optInStatus;
    }

    @JsonProperty(JSON_PROPERTY_OPT_IN_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOptInStatus(OptInStatusEnum optInStatus) {
        this.optInStatus = optInStatus;
    }

    public OptInStatusResponse links(OptInStatusResponseLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OptInStatusResponseLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(OptInStatusResponseLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OptInStatusResponse optInStatusResponse = (OptInStatusResponse) o;
        return Objects.equals(this.optInStatus, optInStatusResponse.optInStatus)
                && Objects.equals(this.links, optInStatusResponse.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(optInStatus, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OptInStatusResponse {\n");
        sb.append("    optInStatus: ").append(toIndentedString(optInStatus)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
