package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OrgCreationAdminCredentialsPassword;
import com.okta.sdk.resource.model.RecoveryQuestionCredential;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies primary authentication and recovery credentials for a User. Credential types and requirements vary
 * depending on the provider and security policy of the org.
 */
@ApiModel(description = "Specifies primary authentication and recovery credentials for a User. Credential types and requirements vary depending on the provider and security policy of the org.")
@JsonPropertyOrder({ OrgCreationAdminCredentials.JSON_PROPERTY_PASSWORD,
        OrgCreationAdminCredentials.JSON_PROPERTY_RECOVERY_QUESTION })
@JsonTypeName("OrgCreationAdmin_credentials")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class OrgCreationAdminCredentials implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_PASSWORD = "password";
    private OrgCreationAdminCredentialsPassword password;

    public static final String JSON_PROPERTY_RECOVERY_QUESTION = "recovery_question";
    private RecoveryQuestionCredential recoveryQuestion;

    public OrgCreationAdminCredentials() {
    }

    public OrgCreationAdminCredentials password(OrgCreationAdminCredentialsPassword password) {

        this.password = password;
        return this;
    }

    /**
     * Get password
     *
     * @return password
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OrgCreationAdminCredentialsPassword getPassword() {
        return password;
    }

    @JsonProperty(JSON_PROPERTY_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPassword(OrgCreationAdminCredentialsPassword password) {
        this.password = password;
    }

    public OrgCreationAdminCredentials recoveryQuestion(RecoveryQuestionCredential recoveryQuestion) {

        this.recoveryQuestion = recoveryQuestion;
        return this;
    }

    /**
     * Get recoveryQuestion
     *
     * @return recoveryQuestion
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_RECOVERY_QUESTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public RecoveryQuestionCredential getRecoveryQuestion() {
        return recoveryQuestion;
    }

    @JsonProperty(JSON_PROPERTY_RECOVERY_QUESTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRecoveryQuestion(RecoveryQuestionCredential recoveryQuestion) {
        this.recoveryQuestion = recoveryQuestion;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OrgCreationAdminCredentials orgCreationAdminCredentials = (OrgCreationAdminCredentials) o;
        return Objects.equals(this.password, orgCreationAdminCredentials.password)
                && Objects.equals(this.recoveryQuestion, orgCreationAdminCredentials.recoveryQuestion);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(password, recoveryQuestion);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrgCreationAdminCredentials {\n");
        sb.append("    password: ").append(toIndentedString(password)).append("\n");
        sb.append("    recoveryQuestion: ").append(toIndentedString(recoveryQuestion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
