package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OrgOktaCommunicationSettingLinksOptIn;
import com.okta.sdk.resource.model.OrgOktaCommunicationSettingLinksOptOut;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available for this object using
 * the [JSON Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06)
 * specification
 */
@ApiModel(description = "Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available for this object using the [JSON Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification")
@JsonPropertyOrder({ OrgOktaCommunicationSettingLinks.JSON_PROPERTY_OPT_IN,
        OrgOktaCommunicationSettingLinks.JSON_PROPERTY_OPT_OUT })
@JsonTypeName("OrgOktaCommunicationSetting__links")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class OrgOktaCommunicationSettingLinks implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_OPT_IN = "optIn";
    private OrgOktaCommunicationSettingLinksOptIn optIn;

    public static final String JSON_PROPERTY_OPT_OUT = "optOut";
    private OrgOktaCommunicationSettingLinksOptOut optOut;

    public OrgOktaCommunicationSettingLinks() {
    }

    public OrgOktaCommunicationSettingLinks optIn(OrgOktaCommunicationSettingLinksOptIn optIn) {

        this.optIn = optIn;
        return this;
    }

    /**
     * Get optIn
     *
     * @return optIn
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_OPT_IN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OrgOktaCommunicationSettingLinksOptIn getOptIn() {
        return optIn;
    }

    @JsonProperty(JSON_PROPERTY_OPT_IN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOptIn(OrgOktaCommunicationSettingLinksOptIn optIn) {
        this.optIn = optIn;
    }

    public OrgOktaCommunicationSettingLinks optOut(OrgOktaCommunicationSettingLinksOptOut optOut) {

        this.optOut = optOut;
        return this;
    }

    /**
     * Get optOut
     *
     * @return optOut
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_OPT_OUT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OrgOktaCommunicationSettingLinksOptOut getOptOut() {
        return optOut;
    }

    @JsonProperty(JSON_PROPERTY_OPT_OUT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOptOut(OrgOktaCommunicationSettingLinksOptOut optOut) {
        this.optOut = optOut;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OrgOktaCommunicationSettingLinks orgOktaCommunicationSettingLinks = (OrgOktaCommunicationSettingLinks) o;
        return Objects.equals(this.optIn, orgOktaCommunicationSettingLinks.optIn)
                && Objects.equals(this.optOut, orgOktaCommunicationSettingLinks.optOut);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(optIn, optOut);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrgOktaCommunicationSettingLinks {\n");
        sb.append("    optIn: ").append(toIndentedString(optIn)).append("\n");
        sb.append("    optOut: ").append(toIndentedString(optOut)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
