package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.PrivilegedAccountStatus;
import com.okta.sdk.resource.model.PrivilegedAccountStatusDetail;
import com.okta.sdk.resource.model.PrivilegedAccountType;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * PrivilegedAccount
 */
@JsonPropertyOrder({ PrivilegedAccount.JSON_PROPERTY_ACCOUNT_TYPE, PrivilegedAccount.JSON_PROPERTY_CREATED,
        PrivilegedAccount.JSON_PROPERTY_DESCRIPTION, PrivilegedAccount.JSON_PROPERTY_ID,
        PrivilegedAccount.JSON_PROPERTY_LAST_UPDATED, PrivilegedAccount.JSON_PROPERTY_NAME,
        PrivilegedAccount.JSON_PROPERTY_OWNER_GROUP_IDS, PrivilegedAccount.JSON_PROPERTY_OWNER_USER_IDS,
        PrivilegedAccount.JSON_PROPERTY_STATUS, PrivilegedAccount.JSON_PROPERTY_STATUS_DETAIL })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "accountType", visible = true, defaultImpl = PrivilegedAccount.class)
@JsonSubTypes({ @JsonSubTypes.Type(value = PrivilegedAccountDetailsAppAccount.class, name = "APP_ACCOUNT"),
        @JsonSubTypes.Type(value = PrivilegedAccountDetailsOktaUserAccount.class, name = "OKTA_USER_ACCOUNT"), })

public class PrivilegedAccount implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ACCOUNT_TYPE = "accountType";
    protected PrivilegedAccountType accountType;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_OWNER_GROUP_IDS = "ownerGroupIds";
    private List<String> ownerGroupIds = null;

    public static final String JSON_PROPERTY_OWNER_USER_IDS = "ownerUserIds";
    private List<String> ownerUserIds = null;

    public static final String JSON_PROPERTY_STATUS = "status";
    private PrivilegedAccountStatus status;

    public static final String JSON_PROPERTY_STATUS_DETAIL = "statusDetail";
    private PrivilegedAccountStatusDetail statusDetail;

    public PrivilegedAccount() {
    }

    /*
     * @JsonCreator public PrivilegedAccount(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated ) { this(); this.created = created; this.id
     * = id; this.lastUpdated = lastUpdated; }
     */

    public PrivilegedAccount accountType(PrivilegedAccountType accountType) {

        this.accountType = accountType;
        return this;
    }

    /**
     * Get accountType
     *
     * @return accountType
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_ACCOUNT_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public PrivilegedAccountType getAccountType() {
        return accountType;
    }

    @JsonProperty(JSON_PROPERTY_ACCOUNT_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setAccountType(PrivilegedAccountType accountType) {
        this.accountType = accountType;
    }

    /**
     * Timestamp when the Privileged Account was created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the Privileged Account was created")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    public PrivilegedAccount description(String description) {

        this.description = description;
        return this;
    }

    /**
     * The description of the Privileged Account
     *
     * @return description
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "This is for accessing AWS Prod-5", value = "The description of the Privileged Account")
    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDescription() {
        return description;
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * The UUID of the Privileged Account
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "a747a818-a4c4-4446-8a87-704216495a08", value = "The UUID of the Privileged Account")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Timestamp when the Privileged Account was last updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the Privileged Account was last updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    public PrivilegedAccount name(String name) {

        this.name = name;
        return this;
    }

    /**
     * The human-readable name for the Privileged Account
     *
     * @return name
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "AWS Prod-5 account", required = true, value = "The human-readable name for the Privileged Account")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public PrivilegedAccount ownerGroupIds(List<String> ownerGroupIds) {

        this.ownerGroupIds = ownerGroupIds;
        return this;
    }

    public PrivilegedAccount addownerGroupIdsItem(String ownerGroupIdsItem) {
        if (this.ownerGroupIds == null) {
            this.ownerGroupIds = new ArrayList<>();
        }
        this.ownerGroupIds.add(ownerGroupIdsItem);
        return this;
    }

    /**
     * A list of IDs of the Okta groups that own the Privileged Account
     *
     * @return ownerGroupIds
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "[\"00g57qp78yZT2XBA40g7\"]", value = "A list of IDs of the Okta groups that own the Privileged Account")
    @JsonProperty(JSON_PROPERTY_OWNER_GROUP_IDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getOwnerGroupIds() {
        return ownerGroupIds;
    }

    @JsonProperty(JSON_PROPERTY_OWNER_GROUP_IDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerGroupIds(List<String> ownerGroupIds) {
        this.ownerGroupIds = ownerGroupIds;
    }

    public PrivilegedAccount ownerUserIds(List<String> ownerUserIds) {

        this.ownerUserIds = ownerUserIds;
        return this;
    }

    public PrivilegedAccount addownerUserIdsItem(String ownerUserIdsItem) {
        if (this.ownerUserIds == null) {
            this.ownerUserIds = new ArrayList<>();
        }
        this.ownerUserIds.add(ownerUserIdsItem);
        return this;
    }

    /**
     * A list of IDs of the Okta users that own the Privileged Account
     *
     * @return ownerUserIds
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "[\"00u11s48P9zGW8yqm0g5\"]", value = "A list of IDs of the Okta users that own the Privileged Account")
    @JsonProperty(JSON_PROPERTY_OWNER_USER_IDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getOwnerUserIds() {
        return ownerUserIds;
    }

    @JsonProperty(JSON_PROPERTY_OWNER_USER_IDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerUserIds(List<String> ownerUserIds) {
        this.ownerUserIds = ownerUserIds;
    }

    public PrivilegedAccount status(PrivilegedAccountStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PrivilegedAccountStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(PrivilegedAccountStatus status) {
        this.status = status;
    }

    public PrivilegedAccount statusDetail(PrivilegedAccountStatusDetail statusDetail) {

        this.statusDetail = statusDetail;
        return this;
    }

    /**
     * Get statusDetail
     *
     * @return statusDetail
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS_DETAIL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PrivilegedAccountStatusDetail getStatusDetail() {
        return statusDetail;
    }

    @JsonProperty(JSON_PROPERTY_STATUS_DETAIL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatusDetail(PrivilegedAccountStatusDetail statusDetail) {
        this.statusDetail = statusDetail;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PrivilegedAccount privilegedAccount = (PrivilegedAccount) o;
        return Objects.equals(this.accountType, privilegedAccount.accountType)
                && Objects.equals(this.created, privilegedAccount.created)
                && Objects.equals(this.description, privilegedAccount.description)
                && Objects.equals(this.id, privilegedAccount.id)
                && Objects.equals(this.lastUpdated, privilegedAccount.lastUpdated)
                && Objects.equals(this.name, privilegedAccount.name)
                && Objects.equals(this.ownerGroupIds, privilegedAccount.ownerGroupIds)
                && Objects.equals(this.ownerUserIds, privilegedAccount.ownerUserIds)
                && Objects.equals(this.status, privilegedAccount.status)
                && Objects.equals(this.statusDetail, privilegedAccount.statusDetail);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountType, created, description, id, lastUpdated, name, ownerGroupIds, ownerUserIds,
                status, statusDetail);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrivilegedAccount {\n");
        sb.append("    accountType: ").append(toIndentedString(accountType)).append("\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    ownerGroupIds: ").append(toIndentedString(ownerGroupIds)).append("\n");
        sb.append("    ownerUserIds: ").append(toIndentedString(ownerUserIds)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    statusDetail: ").append(toIndentedString(statusDetail)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
