package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ProfileMappingPropertyPushStatus;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * A target property, in string form, that maps to a valid [JSON Schema
 * Draft](https://tools.ietf.org/html/draft-zyp-json-schema-04) document.
 */
@ApiModel(description = "A target property, in string form, that maps to a valid [JSON Schema Draft](https://tools.ietf.org/html/draft-zyp-json-schema-04) document.")
@JsonPropertyOrder({ ProfileMappingProperty.JSON_PROPERTY_EXPRESSION,
        ProfileMappingProperty.JSON_PROPERTY_PUSH_STATUS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class ProfileMappingProperty implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EXPRESSION = "expression";
    private String expression;

    public static final String JSON_PROPERTY_PUSH_STATUS = "pushStatus";
    private ProfileMappingPropertyPushStatus pushStatus;

    public ProfileMappingProperty() {
    }

    public ProfileMappingProperty expression(String expression) {

        this.expression = expression;
        return this;
    }

    /**
     * Combination or single source properties that are mapped to the target property
     *
     * @return expression
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Combination or single source properties that are mapped to the target property")
    @JsonProperty(JSON_PROPERTY_EXPRESSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getExpression() {
        return expression;
    }

    @JsonProperty(JSON_PROPERTY_EXPRESSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setExpression(String expression) {
        this.expression = expression;
    }

    public ProfileMappingProperty pushStatus(ProfileMappingPropertyPushStatus pushStatus) {

        this.pushStatus = pushStatus;
        return this;
    }

    /**
     * Get pushStatus
     *
     * @return pushStatus
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PUSH_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProfileMappingPropertyPushStatus getPushStatus() {
        return pushStatus;
    }

    @JsonProperty(JSON_PROPERTY_PUSH_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPushStatus(ProfileMappingPropertyPushStatus pushStatus) {
        this.pushStatus = pushStatus;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProfileMappingProperty profileMappingProperty = (ProfileMappingProperty) o;
        return Objects.equals(this.expression, profileMappingProperty.expression)
                && Objects.equals(this.pushStatus, profileMappingProperty.pushStatus);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(expression, pushStatus);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProfileMappingProperty {\n");
        sb.append("    expression: ").append(toIndentedString(expression)).append("\n");
        sb.append("    pushStatus: ").append(toIndentedString(pushStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
