package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Indicates whether to update target properties for user create and update or just for user create. Having a pushStatus
 * of &#x60;PUSH&#x60; causes properties in the target to be updated on create and update. Having a pushStatus of
 * &#x60;DONT_PUSH&#x60; causes properties in the target to be updated only on create.
 */
public enum ProfileMappingPropertyPushStatus {

    DONT_PUSH("DONT_PUSH"),

    PUSH("PUSH"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    ProfileMappingPropertyPushStatus(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static ProfileMappingPropertyPushStatus fromValue(String value) {
        for (ProfileMappingPropertyPushStatus b : ProfileMappingPropertyPushStatus.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
