package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LinksSelf;
import com.okta.sdk.resource.model.ProviderType;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * PushProvider
 */
@JsonPropertyOrder({ PushProvider.JSON_PROPERTY_ID, PushProvider.JSON_PROPERTY_LAST_UPDATED_DATE,
        PushProvider.JSON_PROPERTY_NAME, PushProvider.JSON_PROPERTY_PROVIDER_TYPE, PushProvider.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "providerType", visible = true, defaultImpl = PushProvider.class)
@JsonSubTypes({ @JsonSubTypes.Type(value = APNSPushProvider.class, name = "APNS"),
        @JsonSubTypes.Type(value = FCMPushProvider.class, name = "FCM"), })

public class PushProvider implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_UPDATED_DATE = "lastUpdatedDate";
    private String lastUpdatedDate;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_PROVIDER_TYPE = "providerType";
    protected ProviderType providerType;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    public PushProvider() {
    }

    /*
     * @JsonCreator public PushProvider(
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED_DATE) String lastUpdatedDate ) { this(); this.id = id;
     * this.lastUpdatedDate = lastUpdatedDate; }
     */

    /**
     * Unique key for the Push Provider
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Unique key for the Push Provider")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Timestamp when the Push Provider was last modified
     *
     * @return lastUpdatedDate
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Timestamp when the Push Provider was last modified")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED_DATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLastUpdatedDate() {
        return lastUpdatedDate;
    }

    public PushProvider name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Display name of the push provider
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Display name of the push provider")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public PushProvider providerType(ProviderType providerType) {

        this.providerType = providerType;
        return this;
    }

    /**
     * Get providerType
     *
     * @return providerType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PROVIDER_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProviderType getProviderType() {
        return providerType;
    }

    @JsonProperty(JSON_PROPERTY_PROVIDER_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProviderType(ProviderType providerType) {
        this.providerType = providerType;
    }

    public PushProvider links(LinksSelf links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksSelf getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PushProvider pushProvider = (PushProvider) o;
        return Objects.equals(this.id, pushProvider.id)
                && Objects.equals(this.lastUpdatedDate, pushProvider.lastUpdatedDate)
                && Objects.equals(this.name, pushProvider.name)
                && Objects.equals(this.providerType, pushProvider.providerType)
                && Objects.equals(this.links, pushProvider.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, lastUpdatedDate, name, providerType, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PushProvider {\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdatedDate: ").append(toIndentedString(lastUpdatedDate)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    providerType: ").append(toIndentedString(providerType)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
