package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.RegistrationInlineHookRequestType;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * RegistrationInlineHookRequest
 */
@JsonPropertyOrder({ RegistrationInlineHookRequest.JSON_PROPERTY_EVENT_TYPE,
        RegistrationInlineHookRequest.JSON_PROPERTY_REQUEST_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "requestType", visible = true, defaultImpl = RegistrationInlineHookRequest.class)
@JsonSubTypes({ @JsonSubTypes.Type(value = RegistrationInlineHookPPData.class, name = "progressive.profile"),
        @JsonSubTypes.Type(value = RegistrationInlineHookSSRData.class, name = "self.service.registration"), })

public class RegistrationInlineHookRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EVENT_TYPE = "eventType";
    private String eventType;

    public static final String JSON_PROPERTY_REQUEST_TYPE = "requestType";
    protected RegistrationInlineHookRequestType requestType;

    public RegistrationInlineHookRequest() {
    }

    public RegistrationInlineHookRequest eventType(String eventType) {

        this.eventType = eventType;
        return this;
    }

    /**
     * The type of inline hook. The registration inline hook type is &#x60;com.okta.user.pre-registration&#x60;.
     *
     * @return eventType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The type of inline hook. The registration inline hook type is `com.okta.user.pre-registration`.")
    @JsonProperty(JSON_PROPERTY_EVENT_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getEventType() {
        return eventType;
    }

    @JsonProperty(JSON_PROPERTY_EVENT_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public RegistrationInlineHookRequest requestType(RegistrationInlineHookRequestType requestType) {

        this.requestType = requestType;
        return this;
    }

    /**
     * Get requestType
     *
     * @return requestType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_REQUEST_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public RegistrationInlineHookRequestType getRequestType() {
        return requestType;
    }

    @JsonProperty(JSON_PROPERTY_REQUEST_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRequestType(RegistrationInlineHookRequestType requestType) {
        this.requestType = requestType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RegistrationInlineHookRequest registrationInlineHookRequest = (RegistrationInlineHookRequest) o;
        return Objects.equals(this.eventType, registrationInlineHookRequest.eventType)
                && Objects.equals(this.requestType, registrationInlineHookRequest.requestType);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(eventType, requestType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RegistrationInlineHookRequest {\n");
        sb.append("    eventType: ").append(toIndentedString(eventType)).append("\n");
        sb.append("    requestType: ").append(toIndentedString(requestType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
