package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ResourceSelectorResponseSchemaLinks;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * ResourceSelectorResponseSchema
 */
@JsonPropertyOrder({ ResourceSelectorResponseSchema.JSON_PROPERTY_DESCRIPTION,
        ResourceSelectorResponseSchema.JSON_PROPERTY_ID, ResourceSelectorResponseSchema.JSON_PROPERTY_NAME,
        ResourceSelectorResponseSchema.JSON_PROPERTY_ORN, ResourceSelectorResponseSchema.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class ResourceSelectorResponseSchema implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_ORN = "orn";
    private String orn;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private ResourceSelectorResponseSchemaLinks links;

    public ResourceSelectorResponseSchema() {
    }

    public ResourceSelectorResponseSchema description(String description) {

        this.description = description;
        return this;
    }

    /**
     * Description of the Resource Selector
     *
     * @return description
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Description of the Resource Selector")
    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDescription() {
        return description;
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public ResourceSelectorResponseSchema id(String id) {

        this.id = id;
        return this;
    }

    /**
     * Unique key for the Resource Selector
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Unique key for the Resource Selector")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public ResourceSelectorResponseSchema name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Name of the Resource Selector
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the Resource Selector")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public ResourceSelectorResponseSchema orn(String orn) {

        this.orn = orn;
        return this;
    }

    /**
     * An Okta resource name
     *
     * @return orn
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "An Okta resource name")
    @JsonProperty(JSON_PROPERTY_ORN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getOrn() {
        return orn;
    }

    @JsonProperty(JSON_PROPERTY_ORN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOrn(String orn) {
        this.orn = orn;
    }

    public ResourceSelectorResponseSchema links(ResourceSelectorResponseSchemaLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ResourceSelectorResponseSchemaLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(ResourceSelectorResponseSchemaLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourceSelectorResponseSchema resourceSelectorResponseSchema = (ResourceSelectorResponseSchema) o;
        return Objects.equals(this.description, resourceSelectorResponseSchema.description)
                && Objects.equals(this.id, resourceSelectorResponseSchema.id)
                && Objects.equals(this.name, resourceSelectorResponseSchema.name)
                && Objects.equals(this.orn, resourceSelectorResponseSchema.orn)
                && Objects.equals(this.links, resourceSelectorResponseSchema.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(description, id, name, orn, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceSelectorResponseSchema {\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    orn: ").append(toIndentedString(orn)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
