package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies a particular level of risk to match on
 */
@ApiModel(description = "Specifies a particular level of risk to match on")
@JsonPropertyOrder({ RiskScorePolicyRuleCondition.JSON_PROPERTY_LEVEL })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class RiskScorePolicyRuleCondition implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * The level to match
     */
    public enum LevelEnum {
        ANY("ANY"),

        LOW("LOW"),

        MEDIUM("MEDIUM"),

        HIGH("HIGH"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        LevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static LevelEnum fromValue(String value) {
            for (LevelEnum b : LevelEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_LEVEL = "level";
    private LevelEnum level;

    public RiskScorePolicyRuleCondition() {
    }

    public RiskScorePolicyRuleCondition level(LevelEnum level) {

        this.level = level;
        return this;
    }

    /**
     * The level to match
     *
     * @return level
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "The level to match")
    @JsonProperty(JSON_PROPERTY_LEVEL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public LevelEnum getLevel() {
        return level;
    }

    @JsonProperty(JSON_PROPERTY_LEVEL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setLevel(LevelEnum level) {
        this.level = level;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RiskScorePolicyRuleCondition riskScorePolicyRuleCondition = (RiskScorePolicyRuleCondition) o;
        return Objects.equals(this.level, riskScorePolicyRuleCondition.level);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(level);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RiskScorePolicyRuleCondition {\n");
        sb.append("    level: ").append(toIndentedString(level)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
