package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * SAMLPayLoadDataContextAllOfProtocolIssuer
 */
@JsonPropertyOrder({ SAMLPayLoadDataContextAllOfProtocolIssuer.JSON_PROPERTY_ID,
        SAMLPayLoadDataContextAllOfProtocolIssuer.JSON_PROPERTY_NAME,
        SAMLPayLoadDataContextAllOfProtocolIssuer.JSON_PROPERTY_URI })
@JsonTypeName("SAMLPayLoad_data_context_allOf_protocol_issuer")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SAMLPayLoadDataContextAllOfProtocolIssuer implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_URI = "uri";
    private String uri;

    public SAMLPayLoadDataContextAllOfProtocolIssuer() {
    }

    public SAMLPayLoadDataContextAllOfProtocolIssuer id(String id) {

        this.id = id;
        return this;
    }

    /**
     * The unique identifier of the issuer that provided the SAML assertion
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "0oath92zlO60urQOP0g3", value = "The unique identifier of the issuer that provided the SAML assertion")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public SAMLPayLoadDataContextAllOfProtocolIssuer name(String name) {

        this.name = name;
        return this;
    }

    /**
     * The name of the issuer that provided the SAML assertion
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "SAML 2.0 App", value = "The name of the issuer that provided the SAML assertion")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public SAMLPayLoadDataContextAllOfProtocolIssuer uri(String uri) {

        this.uri = uri;
        return this;
    }

    /**
     * The base URI of the SAML endpoint that&#39;s used to assert the authorization
     *
     * @return uri
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "http://www.okta.com/exkth8lMzFm0HZOTU0g3", value = "The base URI of the SAML endpoint that's used to assert the authorization")
    @JsonProperty(JSON_PROPERTY_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUri() {
        return uri;
    }

    @JsonProperty(JSON_PROPERTY_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SAMLPayLoadDataContextAllOfProtocolIssuer saMLPayLoadDataContextAllOfProtocolIssuer = (SAMLPayLoadDataContextAllOfProtocolIssuer) o;
        return Objects.equals(this.id, saMLPayLoadDataContextAllOfProtocolIssuer.id)
                && Objects.equals(this.name, saMLPayLoadDataContextAllOfProtocolIssuer.name)
                && Objects.equals(this.uri, saMLPayLoadDataContextAllOfProtocolIssuer.uri);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, uri);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SAMLPayLoadDataContextAllOfProtocolIssuer {\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    uri: ").append(toIndentedString(uri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
