package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.net.URI;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * SamlAcsInner
 */
@JsonPropertyOrder({ SamlAcsInner.JSON_PROPERTY_INDEX, SamlAcsInner.JSON_PROPERTY_URL })
@JsonTypeName("Saml_acs_inner")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SamlAcsInner implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_INDEX = "index";
    private BigDecimal index;

    public static final String JSON_PROPERTY_URL = "url";
    private URI url;

    public SamlAcsInner() {
    }

    public SamlAcsInner index(BigDecimal index) {

        this.index = index;
        return this;
    }

    /**
     * Index of ACS URL. You can&#39;t reuse the same index in the ACS URL array. minimum: 0 maximum: 65535
     *
     * @return index
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "0", value = "Index of ACS URL. You can't reuse the same index in the ACS URL array.")
    @JsonProperty(JSON_PROPERTY_INDEX)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public BigDecimal getIndex() {
        return index;
    }

    @JsonProperty(JSON_PROPERTY_INDEX)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIndex(BigDecimal index) {
        this.index = index;
    }

    public SamlAcsInner url(URI url) {

        this.url = url;
        return this;
    }

    /**
     * Assertion Consumer Service (ACS) URL
     *
     * @return url
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "https://${org.subdomain}.example.com/saml/login", value = "Assertion Consumer Service (ACS) URL")
    @JsonProperty(JSON_PROPERTY_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public URI getUrl() {
        return url;
    }

    @JsonProperty(JSON_PROPERTY_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUrl(URI url) {
        this.url = url;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SamlAcsInner samlAcsInner = (SamlAcsInner) o;
        return Objects.equals(this.index, samlAcsInner.index) && Objects.equals(this.url, samlAcsInner.url);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(index, url);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamlAcsInner {\n");
        sb.append("    index: ").append(toIndentedString(index)).append("\n");
        sb.append("    url: ").append(toIndentedString(url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
