package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SamlAcsEndpoint;
import com.okta.sdk.resource.model.SamlSsoEndpoint;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * SAML 2.0 HTTP binding settings for IdP and SP (Okta)
 */
@ApiModel(description = "SAML 2.0 HTTP binding settings for IdP and SP (Okta)")
@JsonPropertyOrder({ SamlEndpoints.JSON_PROPERTY_ACS, SamlEndpoints.JSON_PROPERTY_SSO })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SamlEndpoints implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ACS = "acs";
    private SamlAcsEndpoint acs;

    public static final String JSON_PROPERTY_SSO = "sso";
    private SamlSsoEndpoint sso;

    public SamlEndpoints() {
    }

    public SamlEndpoints acs(SamlAcsEndpoint acs) {

        this.acs = acs;
        return this;
    }

    /**
     * Get acs
     *
     * @return acs
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ACS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SamlAcsEndpoint getAcs() {
        return acs;
    }

    @JsonProperty(JSON_PROPERTY_ACS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAcs(SamlAcsEndpoint acs) {
        this.acs = acs;
    }

    public SamlEndpoints sso(SamlSsoEndpoint sso) {

        this.sso = sso;
        return this;
    }

    /**
     * Get sso
     *
     * @return sso
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SSO)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SamlSsoEndpoint getSso() {
        return sso;
    }

    @JsonProperty(JSON_PROPERTY_SSO)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSso(SamlSsoEndpoint sso) {
        this.sso = sso;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SamlEndpoints samlEndpoints = (SamlEndpoints) o;
        return Objects.equals(this.acs, samlEndpoints.acs) && Objects.equals(this.sso, samlEndpoints.sso);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(acs, sso);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamlEndpoints {\n");
        sb.append("    acs: ").append(toIndentedString(acs)).append("\n");
        sb.append("    sso: ").append(toIndentedString(sso)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
