package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ProtocolAlgorithmRequestScope;
import com.okta.sdk.resource.model.SamlSigningAlgorithm;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * XML digital Signature Algorithm settings for signing &#x60;&lt;AuthnRequest&gt;&#x60; messages sent to the IdP &gt;
 * **Note:** The &#x60;algorithm&#x60; property is ignored when you disable request signatures (&#x60;scope&#x60; set as
 * &#x60;NONE&#x60;).
 */
@ApiModel(description = "XML digital Signature Algorithm settings for signing `<AuthnRequest>` messages sent to the IdP > **Note:**  The `algorithm` property is ignored when you disable request signatures (`scope` set as `NONE`).")
@JsonPropertyOrder({ SamlRequestSignatureAlgorithm.JSON_PROPERTY_ALGORITHM,
        SamlRequestSignatureAlgorithm.JSON_PROPERTY_SCOPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SamlRequestSignatureAlgorithm implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ALGORITHM = "algorithm";
    private SamlSigningAlgorithm algorithm;

    public static final String JSON_PROPERTY_SCOPE = "scope";
    private ProtocolAlgorithmRequestScope scope;

    public SamlRequestSignatureAlgorithm() {
    }

    public SamlRequestSignatureAlgorithm algorithm(SamlSigningAlgorithm algorithm) {

        this.algorithm = algorithm;
        return this;
    }

    /**
     * Get algorithm
     *
     * @return algorithm
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ALGORITHM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SamlSigningAlgorithm getAlgorithm() {
        return algorithm;
    }

    @JsonProperty(JSON_PROPERTY_ALGORITHM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAlgorithm(SamlSigningAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public SamlRequestSignatureAlgorithm scope(ProtocolAlgorithmRequestScope scope) {

        this.scope = scope;
        return this;
    }

    /**
     * Get scope
     *
     * @return scope
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SCOPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProtocolAlgorithmRequestScope getScope() {
        return scope;
    }

    @JsonProperty(JSON_PROPERTY_SCOPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setScope(ProtocolAlgorithmRequestScope scope) {
        this.scope = scope;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SamlRequestSignatureAlgorithm samlRequestSignatureAlgorithm = (SamlRequestSignatureAlgorithm) o;
        return Objects.equals(this.algorithm, samlRequestSignatureAlgorithm.algorithm)
                && Objects.equals(this.scope, samlRequestSignatureAlgorithm.scope);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(algorithm, scope);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamlRequestSignatureAlgorithm {\n");
        sb.append("    algorithm: ").append(toIndentedString(algorithm)).append("\n");
        sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
