package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The event subjects
 */
@ApiModel(description = "The event subjects")
@JsonPropertyOrder({ SecurityEventSubject.JSON_PROPERTY_DEVICE, SecurityEventSubject.JSON_PROPERTY_TENANT,
        SecurityEventSubject.JSON_PROPERTY_USER })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SecurityEventSubject implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DEVICE = "device";
    private Object device;

    public static final String JSON_PROPERTY_TENANT = "tenant";
    private Object tenant;

    public static final String JSON_PROPERTY_USER = "user";
    private Object user;

    public SecurityEventSubject() {
    }

    public SecurityEventSubject device(Object device) {

        this.device = device;
        return this;
    }

    /**
     * The device involved with the event
     *
     * @return device
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The device involved with the event")
    @JsonProperty(JSON_PROPERTY_DEVICE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Object getDevice() {
        return device;
    }

    @JsonProperty(JSON_PROPERTY_DEVICE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDevice(Object device) {
        this.device = device;
    }

    public SecurityEventSubject tenant(Object tenant) {

        this.tenant = tenant;
        return this;
    }

    /**
     * The tenant involved with the event
     *
     * @return tenant
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The tenant involved with the event")
    @JsonProperty(JSON_PROPERTY_TENANT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Object getTenant() {
        return tenant;
    }

    @JsonProperty(JSON_PROPERTY_TENANT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTenant(Object tenant) {
        this.tenant = tenant;
    }

    public SecurityEventSubject user(Object user) {

        this.user = user;
        return this;
    }

    /**
     * The user involved with the event
     *
     * @return user
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The user involved with the event")
    @JsonProperty(JSON_PROPERTY_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Object getUser() {
        return user;
    }

    @JsonProperty(JSON_PROPERTY_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUser(Object user) {
        this.user = user;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SecurityEventSubject securityEventSubject = (SecurityEventSubject) o;
        return Objects.equals(this.device, securityEventSubject.device)
                && Objects.equals(this.tenant, securityEventSubject.tenant)
                && Objects.equals(this.user, securityEventSubject.user);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(device, tenant, user);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityEventSubject {\n");
        sb.append("    device: ").append(toIndentedString(device)).append("\n");
        sb.append("    tenant: ").append(toIndentedString(tenant)).append("\n");
        sb.append("    user: ").append(toIndentedString(user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
