package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * JSON Web Token header for a Security Event Token
 */
@ApiModel(description = "JSON Web Token header for a Security Event Token")
@JsonPropertyOrder({ SecurityEventTokenRequestJwtHeader.JSON_PROPERTY_ALG,
        SecurityEventTokenRequestJwtHeader.JSON_PROPERTY_KID, SecurityEventTokenRequestJwtHeader.JSON_PROPERTY_TYP })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SecurityEventTokenRequestJwtHeader implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ALG = "alg";
    private String alg;

    public static final String JSON_PROPERTY_KID = "kid";
    private String kid;

    public static final String JSON_PROPERTY_TYP = "typ";
    private String typ;

    public SecurityEventTokenRequestJwtHeader() {
    }

    public SecurityEventTokenRequestJwtHeader alg(String alg) {

        this.alg = alg;
        return this;
    }

    /**
     * Algorithm used to sign or encrypt the JWT
     *
     * @return alg
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "RS256", required = true, value = "Algorithm used to sign or encrypt the JWT")
    @JsonProperty(JSON_PROPERTY_ALG)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getAlg() {
        return alg;
    }

    @JsonProperty(JSON_PROPERTY_ALG)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setAlg(String alg) {
        this.alg = alg;
    }

    public SecurityEventTokenRequestJwtHeader kid(String kid) {

        this.kid = kid;
        return this;
    }

    /**
     * Key ID used to sign or encrypt the JWT
     *
     * @return kid
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Key ID used to sign or encrypt the JWT")
    @JsonProperty(JSON_PROPERTY_KID)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getKid() {
        return kid;
    }

    @JsonProperty(JSON_PROPERTY_KID)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setKid(String kid) {
        this.kid = kid;
    }

    public SecurityEventTokenRequestJwtHeader typ(String typ) {

        this.typ = typ;
        return this;
    }

    /**
     * The type of content being signed or encrypted
     *
     * @return typ
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "secevent+jwt", required = true, value = "The type of content being signed or encrypted")
    @JsonProperty(JSON_PROPERTY_TYP)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getTyp() {
        return typ;
    }

    @JsonProperty(JSON_PROPERTY_TYP)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setTyp(String typ) {
        this.typ = typ;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SecurityEventTokenRequestJwtHeader securityEventTokenRequestJwtHeader = (SecurityEventTokenRequestJwtHeader) o;
        return Objects.equals(this.alg, securityEventTokenRequestJwtHeader.alg)
                && Objects.equals(this.kid, securityEventTokenRequestJwtHeader.kid)
                && Objects.equals(this.typ, securityEventTokenRequestJwtHeader.typ);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(alg, kid, typ);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityEventTokenRequestJwtHeader {\n");
        sb.append("    alg: ").append(toIndentedString(alg)).append("\n");
        sb.append("    kid: ").append(toIndentedString(kid)).append("\n");
        sb.append("    typ: ").append(toIndentedString(typ)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
