package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SecurityEventsProviderSettingsNonSSFCompliant;
import com.okta.sdk.resource.model.SecurityEventsProviderSettingsSSFCompliant;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Information about the Security Events Provider for signal ingestion
 */
@ApiModel(description = "Information about the Security Events Provider for signal ingestion")
@JsonPropertyOrder({ SecurityEventsProviderRequestSettings.JSON_PROPERTY_WELL_KNOWN_URL,
        SecurityEventsProviderRequestSettings.JSON_PROPERTY_ISSUER,
        SecurityEventsProviderRequestSettings.JSON_PROPERTY_JWKS_URL })
@JsonTypeName("SecurityEventsProviderRequest_settings")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SecurityEventsProviderRequestSettings implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_WELL_KNOWN_URL = "well_known_url";
    private String wellKnownUrl;

    public static final String JSON_PROPERTY_ISSUER = "issuer";
    private String issuer;

    public static final String JSON_PROPERTY_JWKS_URL = "jwks_url";
    private String jwksUrl;

    public SecurityEventsProviderRequestSettings() {
    }

    public SecurityEventsProviderRequestSettings wellKnownUrl(String wellKnownUrl) {

        this.wellKnownUrl = wellKnownUrl;
        return this;
    }

    /**
     * The published well-known URL of the Security Events Provider (the SSF transmitter)
     *
     * @return wellKnownUrl
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "https://example.okta.com/.well-known/ssf-configuration", required = true, value = "The published well-known URL of the Security Events Provider (the SSF transmitter)")
    @JsonProperty(JSON_PROPERTY_WELL_KNOWN_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getWellKnownUrl() {
        return wellKnownUrl;
    }

    @JsonProperty(JSON_PROPERTY_WELL_KNOWN_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setWellKnownUrl(String wellKnownUrl) {
        this.wellKnownUrl = wellKnownUrl;
    }

    public SecurityEventsProviderRequestSettings issuer(String issuer) {

        this.issuer = issuer;
        return this;
    }

    /**
     * Issuer URL
     *
     * @return issuer
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "example.okta.com", required = true, value = "Issuer URL")
    @JsonProperty(JSON_PROPERTY_ISSUER)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getIssuer() {
        return issuer;
    }

    @JsonProperty(JSON_PROPERTY_ISSUER)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public SecurityEventsProviderRequestSettings jwksUrl(String jwksUrl) {

        this.jwksUrl = jwksUrl;
        return this;
    }

    /**
     * The public URL where the JWKS public key is uploaded
     *
     * @return jwksUrl
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "https://example.okta.com/oauth2/v1/keys", required = true, value = "The public URL where the JWKS public key is uploaded")
    @JsonProperty(JSON_PROPERTY_JWKS_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getJwksUrl() {
        return jwksUrl;
    }

    @JsonProperty(JSON_PROPERTY_JWKS_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setJwksUrl(String jwksUrl) {
        this.jwksUrl = jwksUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SecurityEventsProviderRequestSettings securityEventsProviderRequestSettings = (SecurityEventsProviderRequestSettings) o;
        return Objects.equals(this.wellKnownUrl, securityEventsProviderRequestSettings.wellKnownUrl)
                && Objects.equals(this.issuer, securityEventsProviderRequestSettings.issuer)
                && Objects.equals(this.jwksUrl, securityEventsProviderRequestSettings.jwksUrl);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(wellKnownUrl, issuer, jwksUrl);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityEventsProviderRequestSettings {\n");
        sb.append("    wellKnownUrl: ").append(toIndentedString(wellKnownUrl)).append("\n");
        sb.append("    issuer: ").append(toIndentedString(issuer)).append("\n");
        sb.append("    jwksUrl: ").append(toIndentedString(jwksUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
