package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.PolicyTypeSimulation;
import com.okta.sdk.resource.model.SimulatePolicyEvaluationsEvaluated;
import com.okta.sdk.resource.model.SimulatePolicyEvaluationsUndefined;
import com.okta.sdk.resource.model.SimulatePolicyResult;
import com.okta.sdk.resource.model.SimulateResultStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * SimulatePolicyEvaluations
 */
@JsonPropertyOrder({ SimulatePolicyEvaluations.JSON_PROPERTY_EVALUATED,
        SimulatePolicyEvaluations.JSON_PROPERTY_POLICY_TYPE, SimulatePolicyEvaluations.JSON_PROPERTY_RESULT,
        SimulatePolicyEvaluations.JSON_PROPERTY_STATUS, SimulatePolicyEvaluations.JSON_PROPERTY_UNDEFINED })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SimulatePolicyEvaluations implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EVALUATED = "evaluated";
    private SimulatePolicyEvaluationsEvaluated evaluated;

    public static final String JSON_PROPERTY_POLICY_TYPE = "policyType";
    private List<PolicyTypeSimulation> policyType = null;

    public static final String JSON_PROPERTY_RESULT = "result";
    private SimulatePolicyResult result;

    public static final String JSON_PROPERTY_STATUS = "status";
    private SimulateResultStatus status;

    public static final String JSON_PROPERTY_UNDEFINED = "undefined";
    private SimulatePolicyEvaluationsUndefined undefined;

    public SimulatePolicyEvaluations() {
    }

    public SimulatePolicyEvaluations evaluated(SimulatePolicyEvaluationsEvaluated evaluated) {

        this.evaluated = evaluated;
        return this;
    }

    /**
     * Get evaluated
     *
     * @return evaluated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_EVALUATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SimulatePolicyEvaluationsEvaluated getEvaluated() {
        return evaluated;
    }

    @JsonProperty(JSON_PROPERTY_EVALUATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEvaluated(SimulatePolicyEvaluationsEvaluated evaluated) {
        this.evaluated = evaluated;
    }

    public SimulatePolicyEvaluations policyType(List<PolicyTypeSimulation> policyType) {

        this.policyType = policyType;
        return this;
    }

    public SimulatePolicyEvaluations addpolicyTypeItem(PolicyTypeSimulation policyTypeItem) {
        if (this.policyType == null) {
            this.policyType = new ArrayList<>();
        }
        this.policyType.add(policyTypeItem);
        return this;
    }

    /**
     * The policy type of the simulate operation
     *
     * @return policyType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The policy type of the simulate operation")
    @JsonProperty(JSON_PROPERTY_POLICY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<PolicyTypeSimulation> getPolicyType() {
        return policyType;
    }

    @JsonProperty(JSON_PROPERTY_POLICY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPolicyType(List<PolicyTypeSimulation> policyType) {
        this.policyType = policyType;
    }

    public SimulatePolicyEvaluations result(SimulatePolicyResult result) {

        this.result = result;
        return this;
    }

    /**
     * Get result
     *
     * @return result
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_RESULT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SimulatePolicyResult getResult() {
        return result;
    }

    @JsonProperty(JSON_PROPERTY_RESULT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setResult(SimulatePolicyResult result) {
        this.result = result;
    }

    public SimulatePolicyEvaluations status(SimulateResultStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SimulateResultStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(SimulateResultStatus status) {
        this.status = status;
    }

    public SimulatePolicyEvaluations undefined(SimulatePolicyEvaluationsUndefined undefined) {

        this.undefined = undefined;
        return this;
    }

    /**
     * Get undefined
     *
     * @return undefined
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_UNDEFINED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SimulatePolicyEvaluationsUndefined getUndefined() {
        return undefined;
    }

    @JsonProperty(JSON_PROPERTY_UNDEFINED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUndefined(SimulatePolicyEvaluationsUndefined undefined) {
        this.undefined = undefined;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SimulatePolicyEvaluations simulatePolicyEvaluations = (SimulatePolicyEvaluations) o;
        return Objects.equals(this.evaluated, simulatePolicyEvaluations.evaluated)
                && Objects.equals(this.policyType, simulatePolicyEvaluations.policyType)
                && Objects.equals(this.result, simulatePolicyEvaluations.result)
                && Objects.equals(this.status, simulatePolicyEvaluations.status)
                && Objects.equals(this.undefined, simulatePolicyEvaluations.undefined);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(evaluated, policyType, result, status, undefined);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SimulatePolicyEvaluations {\n");
        sb.append("    evaluated: ").append(toIndentedString(evaluated)).append("\n");
        sb.append("    policyType: ").append(toIndentedString(policyType)).append("\n");
        sb.append("    result: ").append(toIndentedString(result)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    undefined: ").append(toIndentedString(undefined)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
