package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SsprPrimaryRequirement;
import com.okta.sdk.resource.model.SsprStepUpRequirement;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * &lt;x-lifecycle class&#x3D;\&quot;oie\&quot;&gt;&lt;/x-lifecycle&gt; Describes the initial and secondary
 * authenticator requirements a user needs to reset their password
 */
@ApiModel(description = "<x-lifecycle class=\"oie\"></x-lifecycle> Describes the initial and secondary authenticator requirements a user needs to reset their password")
@JsonPropertyOrder({ SsprRequirement.JSON_PROPERTY_ACCESS_CONTROL, SsprRequirement.JSON_PROPERTY_PRIMARY,
        SsprRequirement.JSON_PROPERTY_STEP_UP })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SsprRequirement implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Determines which authentication requirements a user needs to perform self-service operations.
     * &#x60;AUTH_POLICY&#x60; defers conditions and authentication requirements to the [Okta account management
     * policy](https://developer.okta.com/docs/guides/okta-account-management-policy/main/). &#x60;LEGACY&#x60; refers
     * to the requirements described by this rule.
     */
    public enum AccessControlEnum {
        AUTH_POLICY("AUTH_POLICY"),

        LEGACY("LEGACY"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        AccessControlEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static AccessControlEnum fromValue(String value) {
            for (AccessControlEnum b : AccessControlEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_ACCESS_CONTROL = "accessControl";
    private AccessControlEnum accessControl;

    public static final String JSON_PROPERTY_PRIMARY = "primary";
    private SsprPrimaryRequirement primary;

    public static final String JSON_PROPERTY_STEP_UP = "stepUp";
    private SsprStepUpRequirement stepUp;

    public SsprRequirement() {
    }

    public SsprRequirement accessControl(AccessControlEnum accessControl) {

        this.accessControl = accessControl;
        return this;
    }

    /**
     * Determines which authentication requirements a user needs to perform self-service operations.
     * &#x60;AUTH_POLICY&#x60; defers conditions and authentication requirements to the [Okta account management
     * policy](https://developer.okta.com/docs/guides/okta-account-management-policy/main/). &#x60;LEGACY&#x60; refers
     * to the requirements described by this rule.
     *
     * @return accessControl
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Determines which authentication requirements a user needs to perform self-service operations. `AUTH_POLICY` defers conditions and authentication requirements to the [Okta account management policy](https://developer.okta.com/docs/guides/okta-account-management-policy/main/). `LEGACY` refers to the requirements described by this rule.")
    @JsonProperty(JSON_PROPERTY_ACCESS_CONTROL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AccessControlEnum getAccessControl() {
        return accessControl;
    }

    @JsonProperty(JSON_PROPERTY_ACCESS_CONTROL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAccessControl(AccessControlEnum accessControl) {
        this.accessControl = accessControl;
    }

    public SsprRequirement primary(SsprPrimaryRequirement primary) {

        this.primary = primary;
        return this;
    }

    /**
     * Get primary
     *
     * @return primary
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PRIMARY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SsprPrimaryRequirement getPrimary() {
        return primary;
    }

    @JsonProperty(JSON_PROPERTY_PRIMARY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPrimary(SsprPrimaryRequirement primary) {
        this.primary = primary;
    }

    public SsprRequirement stepUp(SsprStepUpRequirement stepUp) {

        this.stepUp = stepUp;
        return this;
    }

    /**
     * Get stepUp
     *
     * @return stepUp
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STEP_UP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SsprStepUpRequirement getStepUp() {
        return stepUp;
    }

    @JsonProperty(JSON_PROPERTY_STEP_UP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStepUp(SsprStepUpRequirement stepUp) {
        this.stepUp = stepUp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SsprRequirement ssprRequirement = (SsprRequirement) o;
        return Objects.equals(this.accessControl, ssprRequirement.accessControl)
                && Objects.equals(this.primary, ssprRequirement.primary)
                && Objects.equals(this.stepUp, ssprRequirement.stepUp);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(accessControl, primary, stepUp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SsprRequirement {\n");
        sb.append("    accessControl: ").append(toIndentedString(accessControl)).append("\n");
        sb.append("    primary: ").append(toIndentedString(primary)).append("\n");
        sb.append("    stepUp: ").append(toIndentedString(stepUp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
