package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.TokenHookResponseCommandsInnerValueInnerValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * TokenHookResponseCommandsInnerValueInner
 */
@JsonPropertyOrder({ TokenHookResponseCommandsInnerValueInner.JSON_PROPERTY_OP,
        TokenHookResponseCommandsInnerValueInner.JSON_PROPERTY_PATH,
        TokenHookResponseCommandsInnerValueInner.JSON_PROPERTY_VALUE })
@JsonTypeName("TokenHookResponse_commands_inner_value_inner")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class TokenHookResponseCommandsInnerValueInner implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_OP = "op";
    private String op;

    public static final String JSON_PROPERTY_PATH = "path";
    private String path;

    public static final String JSON_PROPERTY_VALUE = "value";
    private TokenHookResponseCommandsInnerValueInnerValue value;

    public TokenHookResponseCommandsInnerValueInner() {
    }

    public TokenHookResponseCommandsInnerValueInner op(String op) {

        this.op = op;
        return this;
    }

    /**
     * The name of one of the supported ops: &#x60;add&#x60;: Add a claim. &#x60;replace&#x60;: Modify an existing claim
     * and update the token lifetime. &#x60;remove&#x60;: Remove an existing claim. #### &#x60;op: add&#x60; notes
     * &lt;details&gt; &lt;summary&gt;Add a claim&lt;/summary&gt; Add a claim **Existing JSON** &#x60;&#x60;&#x60; {
     * \&quot;employeeId\&quot;: \&quot;00u12345678\&quot; } &#x60;&#x60;&#x60; **Operation** &#x60;&#x60;&#x60; {
     * \&quot;commands\&quot;: [ { \&quot;type\&quot;: \&quot;com.okta.assertion.patch\&quot;, \&quot;value\&quot;: [ {
     * \&quot;op\&quot;: \&quot;add\&quot;, \&quot;path\&quot;: \&quot;/claims/extPatientId\&quot;, \&quot;value\&quot;:
     * \&quot;1234\&quot; } ] }, { \&quot;type\&quot;: \&quot;com.okta.assertion.patch\&quot;, \&quot;value\&quot;: [ {
     * \&quot;op\&quot;: \&quot;add\&quot;, \&quot;path\&quot;: \&quot;/claims/external_guid\&quot;,
     * \&quot;value\&quot;: \&quot;F0384685-F87D-474B-848D-2058AC5655A7\&quot; } ] } ] } &#x60;&#x60;&#x60; **Updated
     * JSON** &#x60;&#x60;&#x60; { \&quot;employeeId\&quot;: \&quot;00u12345678\&quot;, \&quot;extPatientId\&quot;:
     * 1234, \&quot;external_guid\&quot;: \&quot;F0384685-F87D-474B-848D-2058AC5655A7\&quot; } &#x60;&#x60;&#x60; &gt;
     * **Note:** If you use the &#x60;add&#x60; operation and include an existing claim in your response with a
     * different value, that value is replaced. Use the &#x60;replace&#x60; operation instead. If you attempt to remove
     * a system-specific claim or use an invalid operation, the entire PATCH fails and errors are logged in the token
     * hooks events. See &#x60;op: replace&#x60; notes. &lt;/details&gt; &lt;details&gt; &lt;summary&gt;Add new members
     * to existing JSON objects&lt;/summary&gt; If you have a JSON object in a claim called
     * &#x60;employee_profile&#x60;, and you want to add the &#x60;department_id&#x60; member to the claim, the existing
     * JSON is updated by specifying the claim in the path, followed by the name of the object member. **Existing JSON**
     * &#x60;&#x60;&#x60; { \&quot;employee_profile\&quot;: { \&quot;employee_id\&quot;: \&quot;1234\&quot;,
     * \&quot;name\&quot;: \&quot;Anna\&quot; } } &#x60;&#x60;&#x60; **Operation** &#x60;&#x60;&#x60; {
     * \&quot;commands\&quot;: [ { \&quot;type\&quot;: \&quot;com.okta.identity.patch\&quot;, \&quot;value\&quot;: [ {
     * \&quot;op\&quot;: \&quot;add\&quot;, \&quot;path\&quot;: \&quot;/claims/employee_profile/department_id\&quot;,
     * \&quot;value\&quot;: \&quot;4947\&quot; } ] } ] } &#x60;&#x60;&#x60; **Updated JSON** &#x60;&#x60;&#x60; {
     * \&quot;employee_profile\&quot;: { \&quot;employee_id\&quot;: \&quot;1234\&quot;, \&quot;name\&quot;:
     * \&quot;Anna\&quot;, \&quot;department_id\&quot;: \&quot;4947\&quot; } } &#x60;&#x60;&#x60; &gt; **Note:** If you
     * attempt to add a member within a JSON object that doesn&#39;t exist or using an invalid operation, the entire
     * PATCH fails and errors are logged in the token hooks events. &lt;/details&gt; &lt;details&gt; &lt;summary&gt;Add
     * new elements to existing arrays&lt;/summary&gt; Append an element to an array by specifying the name of the
     * array, followed by the index where you want to insert the element in the path. Alternatively, you can specify the
     * array name followed by a hyphen (-) in the path to append an element at the end of the array. For example, you
     * have an array that contains the user&#39;s preferred airports, and you want to add a new airport to the array.
     * The existing target JSON object is updated by specifying the claim in the path, followed by the index of where to
     * insert the claim. **Existing JSON** &#x60;&#x60;&#x60; { \&quot;preferred_airports\&quot;:[ \&quot;sjc\&quot;,
     * \&quot;sfo\&quot;, \&quot;oak\&quot; ] } &#x60;&#x60;&#x60; **Operation** &#x60;&#x60;&#x60; {
     * \&quot;commands\&quot;: [ { \&quot;type\&quot;: \&quot;com.okta.identity.patch\&quot;, \&quot;value\&quot;: [ {
     * \&quot;op\&quot;: \&quot;add\&quot;, \&quot;path\&quot;: \&quot;/claims/preferred_airports/3\&quot;,
     * \&quot;value\&quot;: \&quot;lax\&quot; } ] } ] } &#x60;&#x60;&#x60; **Updated JSON** &#x60;&#x60;&#x60; {
     * \&quot;preferred_airports\&quot;:[ \&quot;sjc\&quot;, \&quot;sfo\&quot;, \&quot;oak\&quot;, \&quot;lax\&quot; ] }
     * &#x60;&#x60;&#x60; &gt; **Note:** If you attempt to add an element within an array that doesn&#39;t exist or
     * specify an invalid index, the entire PATCH fails and errors are logged in the token hooks events.
     * &lt;/details&gt; #### &#x60;op: replace&#x60; notes &lt;details&gt; &lt;summary&gt;Modify an existing
     * claim&lt;/summary&gt; You can modify (&#x60;replace&#x60;) existing custom claims or OIDC standard profile
     * claims, such as &#x60;birthdate&#x60; and &#x60;locale&#x60;. You can&#39;t, however, modify any system-specific
     * claims, such as &#x60;iss&#x60; or &#x60;ver&#x60;. Also, you can&#39;t modify a claim that isn&#39;t currently
     * part of the token in the request payload. Attempting to modify a system-specific claim or using an invalid
     * operation results in the entire PATCH failing and errors logged in the token hooks events. See [Access Tokens
     * Scopes and Claims](/openapi/okta-oauth/guides/overview/#access-token-scopes-and-claims) for the list of access
     * token-reserved claims that you can&#39;t modify. &gt; **Note:** Although the &#x60;aud&#x60; and &#x60;sub&#x60;
     * claims are listed as reserved claims, you can modify those claims in access tokens. You can&#39;t modify these
     * claims in ID tokens. See [ID Token Claims](/openapi/okta-oauth/guides/overview/#id-token-claims) for a list of ID
     * token-reserved claims that you can&#39;t modify. **Existing target JSON object** &#x60;&#x60;&#x60; {
     * \&quot;employeeId\&quot;: \&quot;00u12345678\&quot;, \&quot;extPatientId\&quot;: 1234,
     * \&quot;external_guid\&quot;: \&quot;F0384685-F87D-474B-848D-2058AC5655A7\&quot; } &#x60;&#x60;&#x60;
     * **Operation** &#x60;&#x60;&#x60; { \&quot;commands\&quot;: [ { \&quot;type\&quot;:
     * \&quot;com.okta.identity.patch\&quot;, \&quot;value\&quot;: [ { \&quot;op\&quot;: \&quot;replace\&quot;,
     * \&quot;path\&quot;: \&quot;/claims/extPatientId\&quot;, \&quot;value\&quot;: \&quot;12345\&quot; }, {
     * \&quot;op\&quot;: \&quot;replace\&quot;, \&quot;path\&quot;: \&quot;/claims/external_guid\&quot;,
     * \&quot;value\&quot;: \&quot;D1495796-G98E-585C-959E-1269CD6766B8\&quot; } ] } ] } &#x60;&#x60;&#x60; **Updated
     * JSON*** &#x60;&#x60;&#x60; { \&quot;employeeId\&quot;: \&quot;00u12345678\&quot;, \&quot;extPatientId\&quot;:
     * 12345, \&quot;external_guid\&quot;: \&quot;D1495796-G98E-585C-959E-1269CD6766B8\&quot; } &#x60;&#x60;&#x60;
     * &lt;/details&gt; &lt;details&gt; &lt;summary&gt;Modify members within existing JSON objects and
     * arrays&lt;/summary&gt; Use the &#x60;replace&#x60; operation to modify members within JSON objects and elements
     * within arrays. For example, you have a JSON object in a claim called &#x60;employee_profile&#x60;, and you want
     * to update the email address of the employee. The existing target JSON object is updated by specifying the claim
     * in the path, followed by the name of the object member that you want to modify. **Existing target JSON object**
     * &#x60;&#x60;&#x60; { \&quot;employee_profile\&quot;: { \&quot;employee_id\&quot;:\&quot;1234\&quot;,
     * \&quot;name\&quot;:\&quot;Anna\&quot;, \&quot;email\&quot;:\&quot;anna.v@company.com\&quot; } }
     * &#x60;&#x60;&#x60; **Operation** &#x60;&#x60;&#x60; { \&quot;commands\&quot;: [ { \&quot;type\&quot;:
     * \&quot;com.okta.identity.patch\&quot;, \&quot;value\&quot;: [ { \&quot;op\&quot;: \&quot;replace\&quot;,
     * \&quot;path\&quot;: \&quot;/claims/employee_profile/email\&quot;, \&quot;value\&quot;:
     * \&quot;anna@company.com\&quot; } ] } ] } &#x60;&#x60;&#x60; **Updated JSON** &#x60;&#x60;&#x60; {
     * \&quot;employee_profile\&quot;: { \&quot;employee_id\&quot;:\&quot;1234\&quot;,
     * \&quot;name\&quot;:\&quot;Anna\&quot;, \&quot;email\&quot;:\&quot;anna@company.com\&quot; } } &#x60;&#x60;&#x60;
     * &gt; **Note:** If you attempt to modify a member within a JSON object that doesn&#39;t exist or use an invalid
     * operation, the entire PATCH fails and errors are logged in the token hooks events. Similarly, you can replace
     * elements in an array by specifying the array name and the valid index of the element that you want to replace in
     * the path. &lt;/details&gt; &lt;details&gt; &lt;summary&gt;Modify token lifetimes&lt;/summary&gt; You can modify
     * how long the access and ID tokens are valid by specifying the &#x60;lifetime&#x60; in seconds. The
     * &#x60;lifetime&#x60; value must be a minimum of five minutes (300 seconds) and a maximum of 24 hours (86,400
     * seconds). **Operation** &#x60;&#x60;&#x60; { \&quot;commands\&quot;: [ { \&quot;type\&quot;:
     * \&quot;com.okta.identity.patch\&quot;, \&quot;value\&quot;: [ { \&quot;op\&quot;: \&quot;replace\&quot;,
     * \&quot;path\&quot;: \&quot;/token/lifetime/expiration\&quot;, \&quot;value\&quot;: 36000 } ] }, {
     * \&quot;type\&quot;: \&quot;com.okta.access.patch\&quot;, \&quot;value\&quot;: [ { \&quot;op\&quot;:
     * \&quot;replace\&quot;, \&quot;path\&quot;: \&quot;/token/lifetime/expiration\&quot;, \&quot;value\&quot;: 36000 }
     * ] } ] } &#x60;&#x60;&#x60; &lt;/details&gt; #### &#x60;op: remove&#x60; notes &lt;details&gt;
     * &lt;summary&gt;Remove a claim&lt;/summary&gt; You can remove existing custom claims or OIDC standard profile
     * claims, such as &#x60;birthdate&#x60; or &#x60;locale&#x60;. You can&#39;t, however, remove any system-specific
     * claims, such as &#x60;iss&#x60; or &#x60;ver&#x60;. You also can&#39;t remove a claim that isn&#39;t currently
     * part of the token in the request payload. If you attempt to remove a system-specific claim or use an invalid
     * operation, the entire PATCH fails and errors are logged in the token hooks events. See [Access Tokens Scopes and
     * Claims](/openapi/okta-oauth/guides/overview/#access-token-scopes-and-claims) for the list of access
     * token-reserved claims that you can&#39;t modify. See [ID Token
     * Claims](/openapi/okta-oauth/guides/overview/#id-token-claims) for a list of ID token-reserved claims that you
     * can&#39;t modify. **Operation** &#x60;&#x60;&#x60; { \&quot;commands\&quot;: [ { \&quot;type\&quot;:
     * \&quot;com.okta.identity.patch\&quot;, \&quot;value\&quot;: [ { \&quot;op\&quot;: \&quot;remove\&quot;,
     * \&quot;path\&quot;: \&quot;/claims/birthdate\&quot;, \&quot;value\&quot;: null } ] }, { \&quot;type\&quot;:
     * \&quot;com.okta.access.patch\&quot;, \&quot;value\&quot;: [ { \&quot;op\&quot;: \&quot;remove\&quot;,
     * \&quot;path\&quot;: \&quot;/claims/external_guid\&quot; } ] } ] } &#x60;&#x60;&#x60; &gt; **Note:** The
     * &#x60;value&#x60; property for the &#x60;remove&#x60; operation isn&#39;t required. If you provide it in the
     * response, it should be set to &#x60;null&#x60;. Providing any other value fails the entire PATCH response.
     * &lt;/details&gt; &lt;details&gt; &lt;summary&gt;Remove members from existing arrays&lt;/summary&gt; Use the
     * &#x60;remove&#x60; operation to remove members from existing arrays. For example, you have an array that contains
     * the user&#39;s preferred airports, and you want to remove an airport from the array. The existing target JSON
     * object is updated by specifying the array name followed by the index of the element that you want to remove. You
     * don&#39;t need to specify a value for the remove operation, but you can specify &#x60;null&#x60; as the value if
     * you want. **Existing target JSON object** &#x60;&#x60;&#x60; { \&quot;preferred_airports\&quot;: [
     * \&quot;sjc\&quot;, \&quot;lax\&quot;, \&quot;sfo\&quot;, \&quot;oak\&quot; ] } &#x60;&#x60;&#x60; **Operation**
     * &#x60;&#x60;&#x60; { \&quot;commands\&quot;: [ { \&quot;type\&quot;: \&quot;com.okta.identity.patch\&quot;,
     * \&quot;value\&quot;: [ { \&quot;op\&quot;: \&quot;remove\&quot;, \&quot;path\&quot;:
     * \&quot;/claims/preferred_airports/1\&quot; } ] } ] } &#x60;&#x60;&#x60; **Updated JSON** &#x60;&#x60;&#x60; {
     * \&quot;preferred_airports\&quot;: [ \&quot;sjc\&quot;, \&quot;sfo\&quot;, \&quot;oak\&quot; ] }
     * &#x60;&#x60;&#x60; &lt;/details&gt; &lt;details&gt; &lt;summary&gt;Remove members from existing JSON
     * objects&lt;/summary&gt; Use the &#x60;remove&#x60; operation to remove members from existing JSON objects. Do
     * this by specifying the JSON object in the path, followed by the claim member that you would like to remove. For
     * example, you have an &#x60;employee_profile&#x60; claim, and you want to remove &#x60;email&#x60; from it.
     * **Existing target JSON object** &#x60;&#x60;&#x60; { \&quot;employee_profile\&quot;: {
     * \&quot;employee_id\&quot;:\&quot;1234\&quot;, \&quot;name\&quot;:\&quot;Anna\&quot;,
     * \&quot;email\&quot;:\&quot;anna.v@company.com\&quot; } } &#x60;&#x60;&#x60; **Operation** &#x60;&#x60;&#x60; {
     * \&quot;commands\&quot;: [ { \&quot;type\&quot;: \&quot;com.okta.identity.patch\&quot;, \&quot;value\&quot;: [ {
     * \&quot;op\&quot;: \&quot;remove\&quot;, \&quot;path\&quot;: \&quot;/claims/employee_profile/email\&quot; } ] } ]
     * } &#x60;&#x60;&#x60; **Updated JSON** &#x60;&#x60;&#x60; { \&quot;employee_profile\&quot;: {
     * \&quot;employee_id\&quot;:\&quot;1234\&quot;, \&quot;name\&quot;:\&quot;Anna\&quot;, } } &#x60;&#x60;&#x60;
     * &lt;/details&gt;
     *
     * @return op
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The name of one of the supported ops: `add`: Add a claim. `replace`: Modify an existing claim and update the token lifetime. `remove`: Remove an existing claim. #### `op: add` notes  <details> <summary>Add a claim</summary>      Add a claim    **Existing JSON**      ```   {     \"employeeId\": \"00u12345678\"   }   ```    **Operation**    ```   {     \"commands\": [       {         \"type\": \"com.okta.assertion.patch\",         \"value\": [           {             \"op\": \"add\",             \"path\": \"/claims/extPatientId\",             \"value\": \"1234\"           }         ]       },       {         \"type\": \"com.okta.assertion.patch\",         \"value\": [           {             \"op\": \"add\",             \"path\": \"/claims/external_guid\",             \"value\": \"F0384685-F87D-474B-848D-2058AC5655A7\"           }         ]       }     ]   }   ```      **Updated JSON**      ```   {     \"employeeId\": \"00u12345678\",     \"extPatientId\": 1234,     \"external_guid\": \"F0384685-F87D-474B-848D-2058AC5655A7\"   }   ```    > **Note:** If you use the `add` operation and include an existing claim in your response with a different value, that value is replaced. Use the `replace` operation instead. If you attempt to remove a system-specific claim or use an invalid operation, the entire PATCH fails and errors are logged in the token hooks events. See `op: replace` notes. </details>  <details> <summary>Add new members to existing JSON objects</summary>      If you have a JSON object in a claim called `employee_profile`, and you want to add the `department_id` member to the claim, the existing JSON is updated by specifying the claim in the path, followed by the name of the object member.    **Existing JSON**      ```   {     \"employee_profile\": {       \"employee_id\": \"1234\",       \"name\": \"Anna\"     }   }   ```    **Operation**    ```   {     \"commands\": [       {         \"type\": \"com.okta.identity.patch\",         \"value\": [           {             \"op\": \"add\",             \"path\": \"/claims/employee_profile/department_id\",             \"value\": \"4947\"           }         ]       }     ]   }   ```      **Updated JSON**      ```   {     \"employee_profile\": {       \"employee_id\": \"1234\",       \"name\": \"Anna\",       \"department_id\": \"4947\"     }   }   ```    > **Note:** If you attempt to add a member within a JSON object that doesn't exist or using an invalid operation, the entire PATCH fails and errors are logged in the token hooks events. </details>  <details> <summary>Add new elements to existing arrays</summary>      Append an element to an array by specifying the name of the array, followed by the index where you want to insert the element in the path. Alternatively, you can specify the array name followed by a hyphen (-) in the path to append an element at the end of the array. For example, you have an array that contains the user's preferred airports, and you want to add a new airport to the array. The existing target JSON object is updated by specifying the claim in the path, followed by the index of where to insert the claim.      **Existing JSON**      ```   {     \"preferred_airports\":[       \"sjc\",       \"sfo\",       \"oak\"     ]   }   ```    **Operation**    ```   {     \"commands\": [       {         \"type\": \"com.okta.identity.patch\",         \"value\": [           {             \"op\": \"add\",             \"path\": \"/claims/preferred_airports/3\",             \"value\": \"lax\"           }         ]       }     ]   }   ```    **Updated JSON**      ```   {     \"preferred_airports\":[       \"sjc\",       \"sfo\",       \"oak\",       \"lax\"     ]   }   ```      > **Note:** If you attempt to add an element within an array that doesn't exist or specify an invalid index, the entire PATCH fails and errors are logged in the token hooks events. </details>  #### `op: replace` notes  <details> <summary>Modify an existing claim</summary>    You can modify (`replace`) existing custom claims or OIDC standard profile claims, such as `birthdate` and `locale`. You can't, however, modify any system-specific claims, such as `iss` or `ver`. Also, you can't modify a claim that isn't currently part of the token in the request payload. Attempting to modify a system-specific claim or using an invalid operation results in the entire PATCH failing and errors logged in the token hooks events.      See [Access Tokens Scopes and Claims](/openapi/okta-oauth/guides/overview/#access-token-scopes-and-claims) for the list of access token-reserved claims that you can't modify.    > **Note:** Although the `aud` and `sub` claims are listed as reserved claims, you can modify those claims in access tokens. You can't modify these claims in ID tokens.    See [ID Token Claims](/openapi/okta-oauth/guides/overview/#id-token-claims) for a list of ID token-reserved claims that you can't modify.    **Existing target JSON object**    ```   {     \"employeeId\": \"00u12345678\",     \"extPatientId\": 1234,     \"external_guid\": \"F0384685-F87D-474B-848D-2058AC5655A7\"   }   ```    **Operation**    ```   {     \"commands\": [       {         \"type\": \"com.okta.identity.patch\",         \"value\": [           {             \"op\": \"replace\",             \"path\": \"/claims/extPatientId\",             \"value\": \"12345\"           },           {             \"op\": \"replace\",             \"path\": \"/claims/external_guid\",             \"value\": \"D1495796-G98E-585C-959E-1269CD6766B8\"           }         ]       }     ]   }   ```    **Updated JSON***    ```   {     \"employeeId\": \"00u12345678\",     \"extPatientId\": 12345,     \"external_guid\": \"D1495796-G98E-585C-959E-1269CD6766B8\"   }   ```    </details>  <details> <summary>Modify members within existing JSON objects and arrays</summary>      Use the `replace` operation to modify members within JSON objects and elements within arrays. For example, you have a JSON object in a claim called `employee_profile`, and you want to update the email address of the employee. The existing target JSON object is updated by specifying the claim in the path, followed by the name of the object member that you want to modify.    **Existing target JSON object**      ```   {     \"employee_profile\": {       \"employee_id\":\"1234\",       \"name\":\"Anna\",       \"email\":\"anna.v@company.com\"       }   }   ```    **Operation**    ```   {     \"commands\": [       {         \"type\": \"com.okta.identity.patch\",         \"value\": [           {             \"op\": \"replace\",             \"path\": \"/claims/employee_profile/email\",             \"value\": \"anna@company.com\"           }         ]       }     ]   }   ```    **Updated JSON**      ```   {     \"employee_profile\": {       \"employee_id\":\"1234\",       \"name\":\"Anna\",       \"email\":\"anna@company.com\"       }   }   ```    > **Note:** If you attempt to modify a member within a JSON object that doesn't exist or use an invalid operation, the entire PATCH fails and errors are logged in the token hooks events.      Similarly, you can replace elements in an array by specifying the array name and the valid index of the element that you want to replace in the path. </details>  <details> <summary>Modify token lifetimes</summary>   You can modify how long the access and ID tokens are valid by specifying the `lifetime` in seconds. The `lifetime` value must be a minimum of five minutes (300 seconds) and a maximum of 24 hours (86,400 seconds).    **Operation**    ```   {     \"commands\": [       {         \"type\": \"com.okta.identity.patch\",         \"value\": [           {             \"op\": \"replace\",             \"path\": \"/token/lifetime/expiration\",             \"value\": 36000           }         ]       },       {         \"type\": \"com.okta.access.patch\",         \"value\": [           {             \"op\": \"replace\",             \"path\": \"/token/lifetime/expiration\",             \"value\": 36000           }         ]       }     ]   }   ```  </details>  #### `op: remove` notes  <details> <summary>Remove a claim</summary>    You can remove existing custom claims or OIDC standard profile claims, such as `birthdate` or `locale`. You can't, however, remove any system-specific claims, such as `iss` or `ver`. You also can't remove a claim that isn't currently part of the token in the request payload. If you attempt to remove a system-specific claim or use an invalid operation, the entire PATCH fails and errors are logged in the token hooks events.    See [Access Tokens Scopes and Claims](/openapi/okta-oauth/guides/overview/#access-token-scopes-and-claims) for the list of access token-reserved claims that you can't modify.    See [ID Token Claims](/openapi/okta-oauth/guides/overview/#id-token-claims) for a list of ID token-reserved claims that you can't modify.    **Operation**    ```   {     \"commands\": [       {         \"type\": \"com.okta.identity.patch\",         \"value\": [           {             \"op\": \"remove\",             \"path\": \"/claims/birthdate\",             \"value\": null           }         ]       },       {         \"type\": \"com.okta.access.patch\",         \"value\": [           {             \"op\": \"remove\",             \"path\": \"/claims/external_guid\"           }         ]       }     ]   }   ```    > **Note:** The `value` property for the `remove` operation isn't required. If you provide it in the response, it should be set to `null`. Providing any other value fails the entire PATCH response.  </details>  <details> <summary>Remove members from existing arrays</summary>    Use the `remove` operation to remove members from existing arrays. For example, you have an array that contains the user's preferred airports, and you want to remove an airport from the array. The existing target JSON object is updated by specifying the array name followed by the index of the element that you want to remove. You don't need to specify a value for the remove operation, but you can specify `null` as the value if you want.      **Existing target JSON object**      ```   {     \"preferred_airports\": [         \"sjc\",         \"lax\",         \"sfo\",         \"oak\"       ]   }   ```      **Operation**    ```   {     \"commands\": [       {         \"type\": \"com.okta.identity.patch\",         \"value\": [           {             \"op\": \"remove\",             \"path\": \"/claims/preferred_airports/1\"           }         ]       }     ]   }   ```    **Updated JSON**      ```   {     \"preferred_airports\": [         \"sjc\",         \"sfo\",         \"oak\"       ]   }   ```  </details>  <details> <summary>Remove members from existing JSON objects</summary>   Use the `remove` operation to remove members from existing JSON objects. Do this by specifying the JSON object in the path, followed by the claim member that you would like to remove. For example, you have an `employee_profile` claim, and you want to remove `email` from it.  **Existing target JSON object**  ``` {   \"employee_profile\": {     \"employee_id\":\"1234\",     \"name\":\"Anna\",     \"email\":\"anna.v@company.com\"     } } ```  **Operation**  ``` {   \"commands\": [     {       \"type\": \"com.okta.identity.patch\",       \"value\": [         {           \"op\": \"remove\",           \"path\": \"/claims/employee_profile/email\"         }       ]     }   ] } ```  **Updated JSON** ``` {   \"employee_profile\": {     \"employee_id\":\"1234\",     \"name\":\"Anna\",     } } ```  </details>")
    @JsonProperty(JSON_PROPERTY_OP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getOp() {
        return op;
    }

    @JsonProperty(JSON_PROPERTY_OP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOp(String op) {
        this.op = op;
    }

    public TokenHookResponseCommandsInnerValueInner path(String path) {

        this.path = path;
        return this;
    }

    /**
     * Location within the token to apply the operation, specified as a slash-delimited path. When you add, replace, or
     * remove a claim, this path always begins with &#x60;/claims/&#x60; and is followed by the name of the new claim
     * that you&#39;re adding. When you replace a token lifetime, the path should always be
     * &#x60;/token/lifetime/expiration&#x60;.
     *
     * @return path
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Location within the token to apply the operation, specified as a slash-delimited path. When you add, replace, or remove a claim, this path always begins with `/claims/` and is followed by the name of the new claim that you're adding. When you replace a token lifetime, the path should always be `/token/lifetime/expiration`.")
    @JsonProperty(JSON_PROPERTY_PATH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPath() {
        return path;
    }

    @JsonProperty(JSON_PROPERTY_PATH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPath(String path) {
        this.path = path;
    }

    public TokenHookResponseCommandsInnerValueInner value(TokenHookResponseCommandsInnerValueInnerValue value) {

        this.value = value;
        return this;
    }

    /**
     * Get value
     *
     * @return value
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TokenHookResponseCommandsInnerValueInnerValue getValue() {
        return value;
    }

    @JsonProperty(JSON_PROPERTY_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setValue(TokenHookResponseCommandsInnerValueInnerValue value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TokenHookResponseCommandsInnerValueInner tokenHookResponseCommandsInnerValueInner = (TokenHookResponseCommandsInnerValueInner) o;
        return Objects.equals(this.op, tokenHookResponseCommandsInnerValueInner.op)
                && Objects.equals(this.path, tokenHookResponseCommandsInnerValueInner.path)
                && Objects.equals(this.value, tokenHookResponseCommandsInnerValueInner.value);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(op, path, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenHookResponseCommandsInnerValueInner {\n");
        sb.append("    op: ").append(toIndentedString(op)).append("\n");
        sb.append("    path: ").append(toIndentedString(path)).append("\n");
        sb.append("    value: ").append(toIndentedString(value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
