package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.TrustedOriginScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * TrustedOriginWrite
 */
@JsonPropertyOrder({ TrustedOriginWrite.JSON_PROPERTY_NAME, TrustedOriginWrite.JSON_PROPERTY_ORIGIN,
        TrustedOriginWrite.JSON_PROPERTY_SCOPES })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class TrustedOriginWrite implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_ORIGIN = "origin";
    private String origin;

    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private List<TrustedOriginScope> scopes = null;

    public TrustedOriginWrite() {
    }

    public TrustedOriginWrite name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Unique name for the Trusted Origin
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Unique name for the Trusted Origin")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public TrustedOriginWrite origin(String origin) {

        this.origin = origin;
        return this;
    }

    /**
     * Unique origin URL for the Trusted Origin. The supported schemes for this attribute are HTTP, HTTPS, FTP, Ionic 2,
     * and Capacitor.
     *
     * @return origin
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Unique origin URL for the Trusted Origin. The supported schemes for this attribute are HTTP, HTTPS, FTP, Ionic 2, and Capacitor.")
    @JsonProperty(JSON_PROPERTY_ORIGIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getOrigin() {
        return origin;
    }

    @JsonProperty(JSON_PROPERTY_ORIGIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public TrustedOriginWrite scopes(List<TrustedOriginScope> scopes) {

        this.scopes = scopes;
        return this;
    }

    public TrustedOriginWrite addscopesItem(TrustedOriginScope scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    /**
     * Array of Scope types that this Trusted Origin is used for
     *
     * @return scopes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Array of Scope types that this Trusted Origin is used for")
    @JsonProperty(JSON_PROPERTY_SCOPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<TrustedOriginScope> getScopes() {
        return scopes;
    }

    @JsonProperty(JSON_PROPERTY_SCOPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setScopes(List<TrustedOriginScope> scopes) {
        this.scopes = scopes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TrustedOriginWrite trustedOriginWrite = (TrustedOriginWrite) o;
        return Objects.equals(this.name, trustedOriginWrite.name)
                && Objects.equals(this.origin, trustedOriginWrite.origin)
                && Objects.equals(this.scopes, trustedOriginWrite.scopes);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, origin, scopes);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TrustedOriginWrite {\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    origin: ").append(toIndentedString(origin)).append("\n");
        sb.append("    scopes: ").append(toIndentedString(scopes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
