package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.UIElementOptions;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies the configuration of an input field on an enrollment form
 */
@ApiModel(description = "Specifies the configuration of an input field on an enrollment form")
@JsonPropertyOrder({ UIElement.JSON_PROPERTY_LABEL, UIElement.JSON_PROPERTY_OPTIONS, UIElement.JSON_PROPERTY_SCOPE,
        UIElement.JSON_PROPERTY_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class UIElement implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;

    public static final String JSON_PROPERTY_OPTIONS = "options";
    private UIElementOptions options;

    public static final String JSON_PROPERTY_SCOPE = "scope";
    private String scope;

    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public UIElement() {
    }

    public UIElement label(String label) {

        this.label = label;
        return this;
    }

    /**
     * Label name for the UI element
     *
     * @return label
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Label name for the UI element")
    @JsonProperty(JSON_PROPERTY_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLabel() {
        return label;
    }

    @JsonProperty(JSON_PROPERTY_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLabel(String label) {
        this.label = label;
    }

    public UIElement options(UIElementOptions options) {

        this.options = options;
        return this;
    }

    /**
     * Get options
     *
     * @return options
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_OPTIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UIElementOptions getOptions() {
        return options;
    }

    @JsonProperty(JSON_PROPERTY_OPTIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOptions(UIElementOptions options) {
        this.options = options;
    }

    public UIElement scope(String scope) {

        this.scope = scope;
        return this;
    }

    /**
     * Specifies the property bound to the input field. It must follow the format &#x60;#/properties/PROPERTY_NAME&#x60;
     * where &#x60;PROPERTY_NAME&#x60; is a variable name for an attribute in &#x60;profile editor&#x60;.
     *
     * @return scope
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specifies the property bound to the input field. It must follow the format `#/properties/PROPERTY_NAME` where `PROPERTY_NAME` is a variable name for an attribute in `profile editor`.")
    @JsonProperty(JSON_PROPERTY_SCOPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getScope() {
        return scope;
    }

    @JsonProperty(JSON_PROPERTY_SCOPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setScope(String scope) {
        this.scope = scope;
    }

    public UIElement type(String type) {

        this.type = type;
        return this;
    }

    /**
     * Specifies the relationship between this input element and &#x60;scope&#x60;. The &#x60;Control&#x60; value
     * specifies that this input controls the value represented by &#x60;scope&#x60;.
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specifies the relationship between this input element and `scope`. The `Control` value specifies that this input controls the value represented by `scope`.")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UIElement uiElement = (UIElement) o;
        return Objects.equals(this.label, uiElement.label) && Objects.equals(this.options, uiElement.options)
                && Objects.equals(this.scope, uiElement.scope) && Objects.equals(this.type, uiElement.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(label, options, scope, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UIElement {\n");
        sb.append("    label: ").append(toIndentedString(label)).append("\n");
        sb.append("    options: ").append(toIndentedString(options)).append("\n");
        sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
