package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.UserFactorActivateResponseLinks;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserFactorActivateResponse
 */
@JsonPropertyOrder({ UserFactorActivateResponse.JSON_PROPERTY_FACTOR_TYPE,
        UserFactorActivateResponse.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "factorType", visible = true, defaultImpl = UserFactorActivateResponse.class)

public class UserFactorActivateResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Type of the Factor
     */
    public enum FactorTypeEnum {
        CALL("call"),

        EMAIL("email"),

        SMS("sms"),

        PUSH("push"),

        TOKEN_SOFTWARE_TOTP("token:software:totp"),

        U2F("u2f"),

        WEBAUTHN("webauthn"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        FactorTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static FactorTypeEnum fromValue(String value) {
            for (FactorTypeEnum b : FactorTypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_FACTOR_TYPE = "factorType";
    protected FactorTypeEnum factorType;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private UserFactorActivateResponseLinks links;

    public UserFactorActivateResponse() {
    }

    public UserFactorActivateResponse factorType(FactorTypeEnum factorType) {

        this.factorType = factorType;
        return this;
    }

    /**
     * Type of the Factor
     *
     * @return factorType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Type of the Factor")
    @JsonProperty(JSON_PROPERTY_FACTOR_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public FactorTypeEnum getFactorType() {
        return factorType;
    }

    @JsonProperty(JSON_PROPERTY_FACTOR_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFactorType(FactorTypeEnum factorType) {
        this.factorType = factorType;
    }

    public UserFactorActivateResponse links(UserFactorActivateResponseLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserFactorActivateResponseLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(UserFactorActivateResponseLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserFactorActivateResponse userFactorActivateResponse = (UserFactorActivateResponse) o;
        return Objects.equals(this.factorType, userFactorActivateResponse.factorType)
                && Objects.equals(this.links, userFactorActivateResponse.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(factorType, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserFactorActivateResponse {\n");
        sb.append("    factorType: ").append(toIndentedString(factorType)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
