package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.UserFactorLinks;
import com.okta.sdk.resource.model.UserFactorProvider;
import com.okta.sdk.resource.model.UserFactorStatus;
import com.okta.sdk.resource.model.UserFactorType;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserFactorSupported
 */
@JsonPropertyOrder({ UserFactorSupported.JSON_PROPERTY_ENROLLMENT, UserFactorSupported.JSON_PROPERTY_FACTOR_TYPE,
        UserFactorSupported.JSON_PROPERTY_PROVIDER, UserFactorSupported.JSON_PROPERTY_STATUS,
        UserFactorSupported.JSON_PROPERTY_VENDOR_NAME, UserFactorSupported.JSON_PROPERTY_EMBEDDED,
        UserFactorSupported.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class UserFactorSupported implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Indicates if the Factor is required for the specified user
     */
    public enum EnrollmentEnum {
        OPTIONAL("OPTIONAL"),

        REQUIRED("REQUIRED"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        EnrollmentEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static EnrollmentEnum fromValue(String value) {
            for (EnrollmentEnum b : EnrollmentEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_ENROLLMENT = "enrollment";
    private EnrollmentEnum enrollment;

    public static final String JSON_PROPERTY_FACTOR_TYPE = "factorType";
    private UserFactorType factorType;

    public static final String JSON_PROPERTY_PROVIDER = "provider";
    private UserFactorProvider provider;

    public static final String JSON_PROPERTY_STATUS = "status";
    private UserFactorStatus status;

    public static final String JSON_PROPERTY_VENDOR_NAME = "vendorName";
    private String vendorName;

    public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
    private Map<String, Object> embedded = null;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private UserFactorLinks links;

    public UserFactorSupported() {
    }

    /*
     * @JsonCreator public UserFactorSupported(
     *
     * @JsonProperty(JSON_PROPERTY_VENDOR_NAME) String vendorName,
     *
     * @JsonProperty(JSON_PROPERTY_EMBEDDED) Map<String, Object> embedded ) { this(); this.vendorName = vendorName;
     * this.embedded = embedded; }
     */

    public UserFactorSupported enrollment(EnrollmentEnum enrollment) {

        this.enrollment = enrollment;
        return this;
    }

    /**
     * Indicates if the Factor is required for the specified user
     *
     * @return enrollment
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "OPTIONAL", value = "Indicates if the Factor is required for the specified user")
    @JsonProperty(JSON_PROPERTY_ENROLLMENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public EnrollmentEnum getEnrollment() {
        return enrollment;
    }

    @JsonProperty(JSON_PROPERTY_ENROLLMENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEnrollment(EnrollmentEnum enrollment) {
        this.enrollment = enrollment;
    }

    public UserFactorSupported factorType(UserFactorType factorType) {

        this.factorType = factorType;
        return this;
    }

    /**
     * Get factorType
     *
     * @return factorType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_FACTOR_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserFactorType getFactorType() {
        return factorType;
    }

    @JsonProperty(JSON_PROPERTY_FACTOR_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFactorType(UserFactorType factorType) {
        this.factorType = factorType;
    }

    public UserFactorSupported provider(UserFactorProvider provider) {

        this.provider = provider;
        return this;
    }

    /**
     * Get provider
     *
     * @return provider
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserFactorProvider getProvider() {
        return provider;
    }

    @JsonProperty(JSON_PROPERTY_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProvider(UserFactorProvider provider) {
        this.provider = provider;
    }

    public UserFactorSupported status(UserFactorStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserFactorStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(UserFactorStatus status) {
        this.status = status;
    }

    /**
     * Name of the Factor vendor. This is usually the same as the provider except for On-Prem MFA where it depends on
     * administrator settings.
     *
     * @return vendorName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "OKTA", value = "Name of the Factor vendor. This is usually the same as the provider except for On-Prem MFA where it depends on administrator settings.")
    @JsonProperty(JSON_PROPERTY_VENDOR_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getVendorName() {
        return vendorName;
    }

    /**
     * Embedded resources related to the Factor
     *
     * @return embedded
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Embedded resources related to the Factor")
    @JsonProperty(JSON_PROPERTY_EMBEDDED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getEmbedded() {
        return embedded;
    }

    public UserFactorSupported links(UserFactorLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserFactorLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(UserFactorLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserFactorSupported userFactorSupported = (UserFactorSupported) o;
        return Objects.equals(this.enrollment, userFactorSupported.enrollment)
                && Objects.equals(this.factorType, userFactorSupported.factorType)
                && Objects.equals(this.provider, userFactorSupported.provider)
                && Objects.equals(this.status, userFactorSupported.status)
                && Objects.equals(this.vendorName, userFactorSupported.vendorName)
                && Objects.equals(this.embedded, userFactorSupported.embedded)
                && Objects.equals(this.links, userFactorSupported.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(enrollment, factorType, provider, status, vendorName, embedded, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserFactorSupported {\n");
        sb.append("    enrollment: ").append(toIndentedString(enrollment)).append("\n");
        sb.append("    factorType: ").append(toIndentedString(factorType)).append("\n");
        sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    vendorName: ").append(toIndentedString(vendorName)).append("\n");
        sb.append("    embedded: ").append(toIndentedString(embedded)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
