package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.UserRiskGetResponseLinks;
import com.okta.sdk.resource.model.UserRiskLevelAll;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserRiskGetResponse
 */
@JsonPropertyOrder({ UserRiskGetResponse.JSON_PROPERTY_RISK_LEVEL, UserRiskGetResponse.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "riskLevel", visible = true, defaultImpl = UserRiskGetResponse.class)
@JsonSubTypes({ @JsonSubTypes.Type(value = UserRiskLevelExists.class, name = "HIGH"),
        @JsonSubTypes.Type(value = UserRiskLevelExists.class, name = "LOW"),
        @JsonSubTypes.Type(value = UserRiskLevelExists.class, name = "MEDIUM"),
        @JsonSubTypes.Type(value = UserRiskLevelNone.class, name = "NONE"), })

public class UserRiskGetResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_RISK_LEVEL = "riskLevel";
    protected UserRiskLevelAll riskLevel;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private UserRiskGetResponseLinks links;

    public UserRiskGetResponse() {
    }

    public UserRiskGetResponse riskLevel(UserRiskLevelAll riskLevel) {

        this.riskLevel = riskLevel;
        return this;
    }

    /**
     * Get riskLevel
     *
     * @return riskLevel
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_RISK_LEVEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserRiskLevelAll getRiskLevel() {
        return riskLevel;
    }

    @JsonProperty(JSON_PROPERTY_RISK_LEVEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRiskLevel(UserRiskLevelAll riskLevel) {
        this.riskLevel = riskLevel;
    }

    public UserRiskGetResponse links(UserRiskGetResponseLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserRiskGetResponseLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(UserRiskGetResponseLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserRiskGetResponse userRiskGetResponse = (UserRiskGetResponse) o;
        return Objects.equals(this.riskLevel, userRiskGetResponse.riskLevel)
                && Objects.equals(this.links, userRiskGetResponse.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(riskLevel, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserRiskGetResponse {\n");
        sb.append("    riskLevel: ").append(toIndentedString(riskLevel)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
